classdef class_REVS_autoshift
	%UNTITLED5 Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		min_speed_radps;
		min_speed_shift_increment;
		
		max_speed_radps;
		max_speed_shift_increment;
		
		upshift_min_speed_radps;
		required_cost_benefit_ratio;
		downshift_delay_secs;

		upshift_delay_secs;
		upshift_commit_secs;
		downshift_commit_secs;
		upshift_min_torque_reserve_ratio;
		downshift_max_speed_radps ;
		kickdown_trigger_ratio   ;
		kickdown_delay_secs ;
		launch_gear_num = 1;
		restrict_skip_shifts = false;
		restrict_shift_parity = false;
		disable_cost_saving_downshifts = false;
		
		use_engine_speed_mask;
		max_input_torque_curve_Nm;
		max_input_torque_speeds_radps;

		cost_map_speed_radps;
		cost_map_torque_Nm;
		

		cost_map ;
		
	end
	
	methods
		function obj = class_REVS_autoshift(num_gears, engine )
			
			if nargin >= 1
				
				obj.max_speed_radps = Inf * ones(num_gears+1,1);
				obj.max_speed_shift_increment = ones(num_gears+1,1);
				
				obj.min_speed_radps = zeros(num_gears+1,1);
				obj.min_speed_shift_increment = ones(num_gears+1,1);
				
				obj.upshift_min_speed_radps = zeros(num_gears+1,1);
				
				obj.downshift_max_speed_radps = Inf * ones(num_gears+1,1);
				
				obj.required_cost_benefit_ratio = 1.03 * ones(num_gears+1,1);
				
				obj.downshift_delay_secs = zeros(num_gears+1,1);
				obj.downshift_commit_secs  = zeros(num_gears+1,1);
				
				obj.upshift_delay_secs = zeros(num_gears+1,1);
				obj.upshift_commit_secs = zeros(num_gears+1,1);
				
				obj.kickdown_trigger_ratio = ones(num_gears+1,1);
				obj.kickdown_delay_secs =zeros(num_gears+1,1);
				
				
				
				obj.use_engine_speed_mask = zeros(num_gears+1,1);
				
			end
			
			if nargin >= 2
				
				obj.max_input_torque_curve_Nm = engine.full_throttle_torque_Nm;
				obj.max_input_torque_speeds_radps = engine.full_throttle_speed_radps;
				
				obj.cost_map_speed_radps = engine.fuel_map_speed_radps;
				obj.cost_map_torque_Nm = engine.fuel_map_torque_Nm;


				eff_torque_Nm      = [0.00 0.2 0.4 0.60 0.80 1.00] * engine.max_torque_Nm;
				eff_pct            = [0.05 0.80 0.90 0.91 0.92 0.93];
				
				eff_pct            = max(min(eff_pct), interp1(eff_torque_Nm , eff_pct, obj.cost_map_torque_Nm(:), 'linear', 'extrap'));
				
				eff_map            = repmat(eff_pct, 1, length(obj.cost_map_speed_radps));

				obj.cost_map = engine.fuel_map_gps./eff_map;
				
			end
			
		end
		
		function val = as_struct(obj)
			
			fields = fieldnames(obj);
			
			for i = 1:length(fields)
				val.(fields{i}) = obj.(fields{i});							
			end
			
			
		end
		
		
	end
	
end

