classdef class_REVS_battery_thermal
	%class_REVS_battery_thermal
	%   REVS battery model thermal properties
	
	properties
		
	initial_temp_degC;						% Initial battery temperature [degC]
	
	pack_heat_capacity_JpK;					% Heat capacity of the battery_pack [J/degK]
	specific_heat_capacity_JpkgK;			% Specific heat capacity of the battery pack [J/(kg*degK)]
	
	pack_total_conductance_WpK;				% Total thermal condunctance through all pathways;
	
	pack_mass_kg;							% Total pack mass [kg]
	
	%cell_case_thickness_m;					% Case thickness [m] - NOT USED NEEDS CLARIFICATION
	%pack_case_thickness_m;					% Effective Case thickness [m] - NOT USED NEEDS CLARIFICATION

	pack_heat_transfer_area_m2;				% Pack surface area for hear transfer [m^2] 
	
	%case_specific_conductance_WpmK;		% Case thermal conductacance [WpmK] - NOT USED NEEDS CLARIFICATION
	heat_transfer_coefficient_Wpm2K;		% Heat transfer coefficient [Wpm2K] 
	
	
	end
	
	methods
	
		
		function val = get.pack_heat_capacity_JpK( obj)			
			val = REVS_class_default(obj.pack_heat_capacity_JpK, obj.specific_heat_capacity_JpkgK * obj.pack_mass_kg);
		end
		
		
		function val = get.pack_total_conductance_WpK(obj)
			val = REVS_class_default(obj.pack_total_conductance_WpK, obj.pack_heat_transfer_area_m2 * obj.heat_transfer_coefficient_Wpm2K);
		end
		
	end
	
end

