classdef class_REVS_gearbox 
	%class_REVS_gearbox
	%   Definition of REVS gearbox class
	
	properties
		
		% Base Properties
		
		type;							% gearbox type
		
		number;							% Gear Numbers - 0 = Neutral
		ratio;							% Gear Ratios - 0 = Neutral
		inertia_kgm2;					% Gear Inertia kgm2
		efficiency_norm;				% Gear Efficiency - Dynamic Lookup Structure - can be set via single efficiency per gear
		
		common_input_inertia_kgm2;		% Rotational Inertia of Input Shaft & Gears
		common_output_inertia_kgm2;		% Rotational Inertia of Output Shaft & Gears
		

		input_torque_loss_Nm;			% Torque Loss Factor Applied to Gearbox Input - Dynamic Lookup Structure
		output_torque_loss_Nm;			% Torque Loss Factor Applied to Gearbox Output - Dynamic Lookup Structure
			
		shift_duration_secs				% Time required to engage new gear via syncronizer / clutches
		
	end
	
	methods

		
		function obj = class_REVS_gearbox( )	% Constructor
			
% 			obj.input_torque_loss_Nm.axis_1.signal = 'gb_spd_in_radps';
% 			obj.input_torque_loss_Nm.axis_1.breakpoints = [0,1e6];
% 			obj.input_torque_loss_Nm.table = [0,0];
% 			
% 			obj.output_torque_loss_Nm.axis_1.signal = 'gb_spd_out_radps';
% 			obj.output_torque_loss_Nm.axis_1.breakpoints = [0,1e6];
% 			obj.output_torque_loss_Nm.table = [0,0];
% 			
% 			obj.efficiency_norm.axis_1.signal = 'gb_cmd_gear';
% 			obj.efficiency_norm.axis_1.breakpoints = [0,1,100];
% 			obj.efficiency_norm.table = [0,1,1];
			
		end
		
		
		function obj = set.efficiency_norm(obj,val)
			% Allow auto configuration when specifying gear efficiencies
			
			if isnumeric(val) && numel(val) == numel(obj.number)
				
				obj.efficiency_norm.axis_1.signal = 'gb_cmd_gear';
				obj.efficiency_norm.axis_1.breakpoints = obj.number;
				obj.efficiency_norm.table = val;
				
			else
				obj.efficiency_norm = val;
				
			end
			
		end
		
		
		function val = get.efficiency_norm( obj)
			
			if isempty(obj.efficiency_norm)
				val.axis_1.signal = 'gb_cmd_gear';
				val.axis_1.breakpoints = obj.number;
				val.table = ones(size(obj.number));
			else
				val = obj.efficiency_norm;
			end
			
		end
		
		
		
		function val = get.input_torque_loss_Nm( obj)
			
			if isempty(obj.input_torque_loss_Nm)
					val.axis_1.signal = 'gb_spd_in_radps';
					val.axis_1.breakpoints = [0,1e6];
					val.table = [0,0];
			else
				val = obj.input_torque_loss_Nm;
			end
			
		end
		
		function val = get.output_torque_loss_Nm( obj)
			
			if isempty(obj.input_torque_loss_Nm)
					val.axis_1.signal = 'gb_spd_out_radps';
					val.axis_1.breakpoints = [0,1e6];
					val.table = [0,0];
			else
				val = obj.output_torque_loss_Nm;
			end
			
		end
		
		
		
		
	end
	
end

