classdef class_REVS_sim_case
	%UNTITLED Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		
		
		model = 'REVS_VM';
		params = class_REVS_sim_params;
		drive_cycle;
	
		external_data_index;
		use_driven_trace;
		use_external_shift;
		use_external_lockup;
		
		sim_step_time = 0.01;
		sim_start_time_secs = -5;
		
		global_decimation = 1;
		verbose = 0;
		
		data_link = [];						% Optional array of class_test_data objects - Used to provide external data and for post simulation analysis 
		
		
	end
	
	methods
		
		function sim(obj)
			
			obj.load_workspace;
			
			
			
			if isempty(obj.external_data_index)
				ext_idx = 1;
			elseif ischar(obj.external_data_index) &&  strcmpi( obj.external_data_index, 'ALL')
				ext_idx = 1:numel( obj.data_link);
			else
				ext_idx = obj.external_data_index;
			end
			
			
			for i = ext_idx
			
			if obj.use_driven_trace
				drive_cycle = evalin('base','drive_cycle');
				drive_cycle.cycle_time = obj.data_link(i).dyno_speed_mps;
				drive_cycle.cycle_speed_mps = obj.data_link(i).vehicle.dyno_speed_mps;
				assignin('base','drive_cycle',drive_cycle ); 
			end
				
			
			
			
			
			
			evalin('base',['sim ',obj.model,' ;']);
			
			end
			
			
		end
		
		function load_workspace( obj )
			
			% Load Configuration Structure
			REVS.current_model = obj.model;
			REVS.model_architecture = 'REVS_CVM';
			REVS_current_model_type = enum_model_type.ALPHA;

			REVS.sim_step_time_secs = obj.sim_step_time;
			REVS.sim_start_time_secs = obj.sim_start_time_secs; 

			REVS.verbose = obj.verbose;
			REVS.global_decimation = obj.global_decimation;

			assignin('base','REVS',REVS);

			% Load Param Files
			obj.params.load();
			

			% Load Drive Cycle
			if ischar( obj.drive_cycle )
				evalin('base',['load ',obj.drive_cycle,' ;']);
			else
				assignin('base','drive_cycle' , obj.drive_cycle);
			end
			
		end
		
		
		
	end
	
end

