classdef class_REVS_uber_dynamic_lockup
    %class_tableshift
    
    properties 
        transmission_lockup_select = enum_transmission_lockup_select.uber_dynamic;


        transmission.tcc_strategy.lock_table.axis_1.signal = 'ctrl.gear_num';
        transmission.tcc_strategy.lock_table.axis_1.breakpoints = transmission.gear.number(2:end);	
        transmission.tcc_strategy.lock_table.axis_2.signal = 'eng_load_norm';
        transmission.tcc_strategy.lock_table.axis_2.breakpoints = [];
        transmission.tcc_strategy.lock_table.table = convert.rpm2radps*[]; 

        transmission.tcc_strategy.unlock_table.axis_1.signal = 'ctrl.gear_num';
        transmission.tcc_strategy.unlock_table.axis_1.breakpoints = transmission.gear.number(2:end);	
        transmission.tcc_strategy.unlock_table.axis_2.signal = 'eng_load_norm';
        transmission.tcc_strategy.unlock_table.axis_2.breakpoints = [];
        transmission.tcc_strategy.unlock_table.table = convert.rpm2radps*[]; 

        transmission.tcc_strategy.downshift_unlock_condition = [];
        transmission.tcc_strategy.upshift_unlock_condition = [];

        transmission.tcc_strategy.always_unlock_gear = [];
        transmission.tcc_strategy.always_lock_gear = [];

        transmission.tcc_strategy.lock_condition	= '(@gb_spd_in_radps > @table_lock_spd && @trans_curr_gear > transmission.tcc_strategy.always_unlock_gear ) || @trans_curr_gear >= transmission.tcc_strategy.always_lock_gear ';
        transmission.tcc_strategy.unlock_condition	= '(@gb_spd_in_radps < @table_unlock_spd && @trans_curr_gear < transmission.tcc_strategy.always_lock_gear ) || @trans_curr_gear <= transmission.tcc_strategy.always_unlock_gear';

        transmission.tcc_strategy.lockup_delay_secs = [];
        transmission.tcc_strategy.lockup_allowed = [];
    end
        
    
    methods
    end
    
end

