classdef enum_battery_type < Simulink.IntEnumType
    enumeration
        lead_acid(1)
        LiIonPolymer(2)
        LiFePO4_Energy(3)
        LiFePO4_Power(4)
        NiMH(5)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
