classdef enum_engine_pedal_map_type < Simulink.IntEnumType
    enumeration
        lookup_table(0)                         % user provides 2D lookup table of torque given pedal norm and current speed
        linear_WOT(1)                           % pedal is linear from CTT (Closed Throttle Torque)..WOT (Wide Open Throttle torque) @ current speed
        linear_max_engine_torque(2)             % pedal is linear from CTT..max engine torque
        max_engine_power(3)                     % pedal torque maps from CTT..max engine poower @ current speeed
        linear_enhanced_WOT(4)                  % pedal is linear from CTT..110% WOT @ current speed
        linear_enhanced_max_engine_torque(5)    % pedal is linear from CTT..110% max engine torque
    end
    
     methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
