classdef enum_fuel_type < Simulink.IntEnumType
    enumeration
        none(0)
        measured(1)
        generic_gasoline(2)
        generic_diesel(3)
        generic_biodiesel(4)
        generic_E85(5)
        generic_CNG(6)
        generic_LNG(7)
        generic_DME(8)
        generic_LPG(9)
        engine_map(10)
        % etc...
    end
    
     methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
