classdef enum_hybrid_type < Simulink.IntEnumType
    enumeration
        P2(0)
        P2_BAS(1)
        powersplit(3)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
