classdef enum_powertrain_type < Simulink.IntEnumType
    enumeration
        conventional(0)
        P2_hybrid(1)
        P2_hybrid_BAS(2)
        powersplit_hybrid(3)
        ALPHA_conventional(4)
        GEM_conventional(5)
        ricardo_conventional(6)
        battery_electric(7)
        hybrid_BAS(8)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
