classdef enum_speed_source < Simulink.IntEnumType
    enumeration
        vehicle_speed_mph(0)
        gearbox_output_rpm(1)
        vehicle_wheel_rpm(2)
		engine_speed_rpm(3)
        gearbox_input_rpm(4)
        gearbox_input_radps(5)
        gearbox_output_radps(6)
        engine_speed_radps(7)
        vehicle_speed_mps(8)
        vehicle_speed_kmh(9)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
% {enum_speed_source.vehicle_speed_mph, enum_speed_source.gearbox_output_rpm, enum_speed_source.vehicle_wheel_rpm, enum_speed_source.engine_speed_rpm, enum_speed_source.gearbox_input_rpm, enum_speed_source.gearbox_input_radps, enum_speed_source.gearbox_output_radps, enum_speed_source.engine_speed_radps}
