classdef enum_transmission_thermal_type < Simulink.IntEnumType
    enumeration
        none(0)
        constant_temperature(1)
        gradient_temperature(2)
        time_lookup(3)
        thermal_model(4)
    end
    
     methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
