function [ out ] = REVS_cleanup_exe_structure( s , root_str)
%REVS_cleanup_exe_structures Remove strings and other invalid data types
%from structures for executable generation

    if ~isstruct(s)
        out = s;	% Nothing to do
		return
    end

    % 2nd argument only used for recursive calls
    if nargin <2
        root_str = inputname(1);
    end
    
    out = orderfields(s);
    fns = fieldnames(s);
    
    for f = 1:length(fns)
    
		fn = fns{f};
		
		
		for i = 1:length(s)
        
			fv = s(i).(fn);
						
			if isstruct( fv )
				% Recurse on structs    
				out(i).(fn) = [];
				out(i).(fn) = REVS_cleanup_exe_structure( fv, [root_str,'.',fn]);   
			elseif ischar( fv)
				fprintf('Converting character field "%s.%s to uint8"\n',root_str,fn)
				out(i).(fn) = uint8( fv );			
			elseif ~ ( isnumeric( fv ) || islogical( fv ) ) 
				% Remove non numeric fields
				fprintf('Removing non-numeric field "%s.%s"\n',root_str,fn)
				out(i).(fn) = [];
			elseif  any(isinf(fv)  )    
				fprintf('Replacing field Inf in "%s.%s" with 1e10\n',root_str,fn)
				idx = isinf( fv );
				fv( idx ) = 1e10 * sign( fv ( idx ) );
				out(i).(fn) = fv;
			 elseif  any(isnan(fv)  )  
				fprintf('Replacing field NaN in "%s.%s" with 0\n',root_str,fn)    
				idx = isnan( fv );
				fv( idx ) = 0.0;
				out(i).(fn) = fv;
			end
			
        
		end

		%length(out) > 1 &&
		
		if all( cellfun( @isempty, {out.(fn)}))			
			out = rmfield(out,fn);
		end
		

    end


end





