function  REVS_gen_exe_input( fname, exe_info , varargin)
%REVS_GEN_EXE_INPUT
%   Write workspace variables to text file for input into a compiled REVS
%   model executable. Currently handles scalar structures, numeric and
%   character arrays, and enumerated types.  Note that the data in the
%   resultant text file will appear transposed from its MATLAB format/

% exe_info = parse_varargs( varargin, 'exe_info',struct('lookup_info',{},'base_parameters',{},'full_parameters',{}) );

 

fid = fopen(fname,'w');

if fid <= 0
    error('Unable to create output file');
end



ws = warning( 'off','backtrace');


for t = 1:length(exe_info.dyn_lookup_info)
    
    try 
        lookup = evalin('caller',exe_info.dyn_lookup_info{t}.base_param);
        if isempty(lookup)
            warning('Table %s is empty!', exe_info.dyn_lookup_info{t}.base_param )
            continue;
        end
    catch
        warning('Table %s not found in workspace!', exe_info.dyn_lookup_info{t}.base_param )
        continue;
    end

    lookup_info = exe_info.dyn_lookup_info{t} ;
    
        
        in_dims = size(lookup.table);
        in_dims = in_dims( in_dims > 1 );
        
        if length( in_dims)  ~= length( lookup_info.max_dims)
            error('Mismatch between number of dimensions in table %s, executable assumes %d while %d were provided', lookup_info.base_param, length( lookup_info.max_dims), length( in_dims) );
        end
            
        if any( in_dims > lookup_info.max_dims)
            error('Mismatch between size of dimensions in table %s, executable assumes [%s] while [%s] was provided', lookup_info.base_param, int2str( lookup_info.max_dims), int2str( in_dims) );
        end
        
        for d = 1:length(in_dims)
                      
           if ~strcmp(lookup.(['axis_',int2str(d)]).signal  , lookup_info.bus_signals{d} )
                warning('Bus Signal Mismatch for axis %d of dynamic lookup %s, executable is ''%s'' while ''%s'' was provided', d, lookup_info.base_param, lookup_info.bus_signals{d} , lookup.(['axis_',int2str(d)]).signal );
           end
           
           if in_dims( d ) ~= length(lookup.(['axis_',int2str(d)]).breakpoints )
                error('Mismatch  between provided table and breakpoint data for axis %d of dynamic lookup %s', d, lookup_info.base_param );
           end
            
        end
        
        fprintf(fid,'Parameter: %s.table_size\r\n', lookup_info.base_param);            
        fprintf(fid, '%d  ', in_dims-1);
        fprintf(fid,'\r\n\r\n');

end


for t = 1:length(exe_info.nD_lookup_info)
    
    try 
        lookup = evalin('caller',exe_info.nD_lookup_info{t}.base_param );
    catch
        warning('Table %s not found in workspace!',exe_info.nD_lookup_info{t}.base_param  )
        continue;
    end

    lookup_info = exe_info.nD_lookup_info{t} ;
    in_dims = size(lookup);
    in_dims = in_dims( in_dims > 1 );
        
        if length( in_dims)  ~= length( lookup_info.max_dims)
            error('Mismatch between number of dimensions in table %s, executable assumes %d while %d were provided', lookup_info.base_param, length( lookup_info.max_dims), length( in_dims) );
        end
        
        if any( in_dims > lookup_info.max_dims)
            error('Mismatch between size of dimensions in table %s, executable assumes [%s] while [%s] was provided', lookup_info.base_param, int2str( lookup_info.max_dims), int2str( in_dims) );
        end

        fprintf(fid,'Parameter: %s_size\r\n', lookup_info.base_param);            
        fprintf(fid, '%d  ', in_dims-1);
        fprintf(fid,'\r\n\r\n');
        
end


% Begin Processing Individual Items
for l = 1:length(exe_info.full_parameters)
      
    try 
        var = evalin('caller',exe_info.full_parameters{l} );
    catch
        warning('Variable %s not found in workspace!', exe_info.full_parameters{l} )
        continue;
    end
    
    % Convert Enum to value
    if isobject(var) && ismethod(var,'real')
        var = var.real;
    end
    
    if isnumeric( var) || islogical(var)
        
        if isrow(var)  % Convert columns to rows to become columns in output file
            var = var';
        end
        
        var_size =  size(var);
        var_dims = length(var_size);
        var_mats = prod(var_size(3:end));
        
        if isfloat(var)
            print_str = [repmat('%12.8g  ',1,var_size(1)),'\r\n'];
        else
            print_str = [repmat('%d  ',1,var_size(1)),'\r\n'];
        end
        
        for m = 1:var_mats
            fprintf(fid,'Parameter: %s', exe_info.full_parameters{l});
            
            if var_dims > 2
                sub_array = ind2subarray( var_size, m * prod(var_size(1:2)));
                fprintf(fid,'(:,:');
                fprintf(fid,',%d', sub_array(3:var_dims) );
                fprintf(fid,')');
            end
            
            fprintf(fid,'\r\n');
            
            
            for r = 1:var_size(2)
                fprintf(fid, print_str, var(:,r,m));
            end
            
            fprintf(fid,'\r\n'); % Add Row Between Blocks
        end
        
    elseif ischar( var )
        fprintf(fid,'Parameter: %s \r\n', exe_info.full_parameters{l});
        fprintf(fid, '"%s"\r\n', var);
        fprintf(fid, '\r\n');
    else
        fprintf( 'Unable to write variable %s to file!\n', var_list{l} );
    end
    
    
end

warning(ws);

fclose(fid);

end





function out = ind2subarray(siz, ndx )

siz = double(siz);

out = [];

k = [1 cumprod(siz(1:end-1))];

for i = length(siz):-1:1,
    vi = rem(ndx-1, k(i)) + 1;
    vj = (ndx - vi)/k(i) + 1;
    out(i) = double(vj);
    ndx = vi;
end
end
