function REVS_run_exe_batch(model, in_files, varargin)

parallel = parse_varargs(varargin,'parallel',0,'numeric',{'scalar'});

log_files = parse_varargs(varargin,'log_files',{},'cell');
log_output = ~isempty(log_files) || parse_varargs(varargin,'log_enable',false,'toggle');

out_files = parse_varargs(varargin,'out_files',{},'cell');

if isempty( model)
    error('First argument must a valid executable model or cell array of models');
elseif ischar(model)
    model = {model};
end

model = regexprep(model,'(?<!\.exe)$','.exe','emptymatch');
models = unique(model);

if length( model) > 1 && length( model ) ~= length(in_files)
    error('Provided model name array must be same size as input file name array');
end

for i = 1:length(models)
    if  ~( exist(char(models{i}),'file') )
        error('First Argument must be a valid executable model or cell array of model executables')
    end
end

if isempty( out_files)
    out_files = regexprep(in_files(:,1),'\.[^\.]*$','.mat');
elseif length(out_files) ~= length(in_files)
    error('Provided output file name array must be same size as input file name array');
end

if ~log_output || 0
    log_files = {' '};
elseif isempty( log_files)
    log_files = strcat( {'> '},regexprep(in_files,'\.[^\.]*$','.log'), {' 2>&1 '});
elseif length(log_files) ~= length(in_files)
    error('Provided log file name array must be same size as input file name array');
else
    log_files = strcat( {' > '},log_files, {' 2>&1 '});
end


% Handle multiple input files - multi column cell array
in_files = regexprep(strcat( {' -i '}, in_files), '^ -i $','');
combined_in_files = cell( size(in_files,1), 1);
for i = 1:size(in_files,2)
	combined_in_files = strcat(combined_in_files, in_files(:,i));
end


% Construct executable command
batch_runs = strcat( model, combined_in_files, {' -o '}, out_files, {' '},log_files);
%batch_runs = sprintf('%s -i %s -o %s %s', model, in_files, out_files,log_files)

fid = fopen('REVS_batch_job.txt','w');

fprintf(fid,'%s\n',batch_runs{:});

fclose(fid);

batch_loc = which('REVS_run_exe_batch.bat');
cmd = sprintf('"%s" %s %d', batch_loc, 'REVS_batch_job.txt', parallel);

system(cmd);

end