function REVS_setup_dynamic_table_size( mdl, vars )
%REVS_setup_dynamic_table_size( model, vars )
%   Converts appropriate lookup table blocks to be dynamically sized for
%   executable generation.  

for i=1:size(vars,1)

in_var = vars{i,1};
size_var = vars{i,2};
    
% Adding Size Variable to Workspace

fprintf('Adding Size Variable to Workspace: %s \n',size_var);

var_size = evalin('base',['size( ' in_var ') ;' ]) - 1; 
var_size = var_size( var_size > 0 );
evalin('base',[size_var ' = uint32( [' num2str(var_size) '] );' ]); 


fprintf('Searching for usage of: %s \n',in_var);

regex = ['^', repmat('(', 1,sum(in_var == '.')), strrep( in_var, '.' , '.)?'), '$'];


blks = find_system(mdl,'lookundermasks','all','followlinks','on','regexp','on','blocktype','Lookup_n-D','Table', regex );   
    
    
    for j = 1:length(blks)
       
            blk_in_var = get_param(blks{j},'Table');
            
            p = regexprep(blk_in_var,'\.\w+$','.');
            
            if isempty(strfind(size_var,p))
                blk_size_var = size_var;
            else
                blk_size_var = regexprep(size_var,'^(\w+\.)*',p);
            end
                
            fprintf('-Updating Block: %s \n',blks{j});
           	set_param(blks{j},'SupportTunableTableSize','on');
            set_param(blks{j},'MaximumIndicesForEachDimension', blk_size_var);
        
    end
    

end


end

