

if exist('REVS','var') && REVS.verbose  disp('Loading Ambient Parameters for Code Generation Parameters'); end;


%% Define Ambient Temperature
ambient.temperature_degC    = 25;           % [C]    

%% Define Atmospheric Pressure
ambient.pressure_Pa         = 101325;        % [Pa]

%% Air gas constant
ambient.Rgas_JpkgK          = 286.9;        % J/kg-k

%% Define Gravitational Acceleration
ambient.gravity_mps2        = 9.81;         % [m/s^2]

ambient.air_density_kgpm3   = ambient.pressure_Pa/ambient.Rgas_JpkgK/(ambient.temperature_degC+273.15);      % [kg/m^3]  
 

