
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

%% Define Electrical Accessory Power (W)
electric.constant_power_accessories.power_W = 600;  % at 55 mph, 10.44 A @ 14.2 V plus ~50% efficiency is ~300W

electric.constant_power_accessories.inertia_kgm2 = 0;

ac_load = false;

electric.air_conditioner.inertia_kgm2 = 0;
electric.air_conditioner.speed_ratio  = 1;
electric.air_conditioner.displacement_cc = 0;
electric.air_conditioner.fan_power_W = 0;
electric.air_conditioner.power_transmission_ratio = 1.0;

electric.air_conditioner.map_displacement_cc = linspace(0,eps,100);
electric.air_conditioner.map_speed_radps = linspace(0,eps,100);
electric.air_conditioner.map_power_kW = zeros( length(electric.air_conditioner.map_speed_radps),length(electric.air_conditioner.map_displacement_cc));



run('param_files/battery_lead_acid_pack.m');
electric.battery = calcs_battery(electric.battery,false);


%% Starter and Alternator Specs
electric.starter.min_voltage_V = 6;
electric.starter.cranking_speed_radps = 0;
electric.starter.efficiency_norm = 0.5;
electric.starter.inertia_kgm2 = 0.025;
electric.starter.max_torque_Nm = 0;

electric.alternator.target_voltage_V = 14;
electric.alternator.activate_speed_radps = 1;
electric.alternator.deactivate_speed_radps = 0;
electric.alternator.inertia_kgm2 = 0;
electric.alternator.efficiency_norm = 0.65;
electric.alternator.max_current_A = 80;