




if exist('REVS','var') && REVS.verbose  disp('Loading Engine for Code Generation Parameters'); end;


DIM = 100;

%% Define Engine Inertia (kg-m^2) and engine idle speed
engine.inertia_kgm2 = 0.0; % from SWRI model
engine.idle_speed_radps = 0;
engine.initial_speed_radps = 1;

engine.idling_activation_speed_radps = 1;
engine.idling_deactivation_speed_radps = 0;

%% Define General Engine Parameters
% .. density of diesel fuel (kg/L)
%engine.fuel_density_kgpL_15C = 0.847;   % original value
engine.fuel_density_kgpL_15C = 0.839984255;   % from SWRI 7.01 lbs/gallon / 2.20462 kg/lb / 3.78541178 gal/L
engine.fuel_energy_density_MJpkg = 42.784;  % from a DOE 18394 BTU/lb for #2 diesel

%% Define Wide-Open Throttle (WOT) Torque Table
engine.full_throttle_speed_radps		= linspace(0,eps,DIM);
engine.full_throttle_torque_Nm			= zeros( 1,DIM );
engine.full_throttle_power_W                          = zeros( 1,DIM );
engine.max_power_W = UNSPECIFIED;
engine.max_power_rpm = UNSPECIFIED;
engine.max_power_radps = UNSPECIFIED;
engine.max_power_min_rpm = UNSPECIFIED;
engine.max_power_min_radps = UNSPECIFIED;
engine.min_torque_Nm = UNSPECIFIED;

   
%% Define Closed Throttle Torque Table
engine.closed_throttle_speed_radps     = linspace(0,eps,DIM);
engine.closed_throttle_torque_Nm       = zeros( 1,DIM );

% engine.pedal_map_type = enum_engine_pedal_map_type.linear_max_engine_torque; 
engine.pedal_map_type			= enum_engine_pedal_map_type.lookup_table;
engine.pedal_map_radps			= linspace(0,eps,DIM);
engine.pedal_map_pedal_norm		= linspace(0,eps,DIM);
engine.pedal_map_Nm				= zeros(DIM,DIM);

engine.decel_fuel_shutoff_disabled = false;

%% Modified Idle Point & Expanded Negative Torques
%% Define Engine Fuel Map Axes
% .. engine speed axis (RPM)
engine.fuel_map_speed_radps		= linspace(0,eps,DIM)';
engine.fuel_map_torque_Nm		= linspace(0,eps,DIM)';
engine.fuel_map_gps			= ones(DIM,DIM);

engine.idling_Kp = UNSPECIFIED;
engine.idling_Ki = UNSPECIFIED;
engine.idling_Kd = UNSPECIFIED;

engine.inertia_compensate_fuel_adjust_norm = UNSPECIFIED;

engine.constant_power_accessories.power_W = UNSPECIFIED;
engine.constant_power_accessories.inertia_kgm2 = UNSPECIFIED;
