%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameter Initialization for AUtomated Manual Transmission System
% - This file initializes model parameters of Transmission System for GEM.
%
% - Assessment & Standards Division
%   Office of Transportation & Air Quality
%   US Environmental Protection Agency
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if exist('REVS','var') && REVS.verbose  disp('Loading AMT for Code Generation Parameters'); end;

DIM = 100;


transmission_type = enum_transmission_type.AMT;

transmission.clutch.clutched_upshift = true;

% Define Clutch Characteristics
transmission.clutch.input_inertia_kgm2 = 0.0;
transmission.clutch.output_inertia_kgm2 = 0.0;
transmission.clutch.torque_capacity_Nm = 0.0;


% Define Gear Characteristics
transmission.gear.number =				1:99; %zeros(1,DIM); % [0:(DIM-1)];
transmission.gear.ratio  =				zeros(size(transmission.gear.number));
transmission.gear.inertia_kgm2 =		zeros(size(transmission.gear.number));
transmission.gear.efficiency_norm =		zeros(size(transmission.gear.number));
transmission.gear.torque_limit_Nm =		zeros(size(transmission.gear.number));
transmission.gear.disable_dynamic_ratio = true;


transmission.gear.common_input_inertia_kgm2 = 0.0;
transmission.gear.common_output_inertia_kgm2 = 0.0;

transmission.gear.spin_loss_speed_radps =	linspace(0,eps,DIM);			
transmission.gear.spin_loss_torque_Nm = zeros(length(transmission.gear.number),length(transmission.gear.spin_loss_speed_radps) );

transmission.gear.inertia_brake_gain = UNSPECIFIED;
transmission.gear.inertia_brake_capacity_Nm = UNSPECIFIED;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Transmission Control Tuning Parameters


% Clutch Engage Characteristics
transmission.clutch.engage_pedal_norm = UNSPECIFIED;

transmission.clutch.engage_speed_radps = UNSPECIFIED;		
transmission.clutch.engage_modulation_max_gear = UNSPECIFIED;		
transmission.clutch.engage_min_norm = UNSPECIFIED;
transmission.clutch.engage_duration_secs = UNSPECIFIED;					
transmission.clutch.engage_Ki = UNSPECIFIED;
transmission.clutch.engage_Kp = UNSPECIFIED;

% Clutch Disengage Characteristics
transmission.clutch.disengage_speed_radps = UNSPECIFIED;	
transmission.clutch.disengage_max_gear = UNSPECIFIED;				

% Define Shift Characteristics
transmission.gear.shift_neutral_delay_secs = 1;				
transmission.gear.shift_duration_secs = 1;					
transmission.gear.shift_speed_tolerance_radps = 100 * convert.rpm2radps;	
transmission.gear.shift_torque_request_Nm = 0;


