
if exist('REVS','var') && REVS.verbose  disp('Loading AT for Code Generation Parameters'); end;

transmission_type = enum_transmission_type.automatic;

transmission.gear.shift_duration_secs = 0;

%transmission.torque_converter.init_function         = 'calcs_torque_converter';
transmission.torque_converter.lockup_delay_secs     = 0;
transmission.torque_converter.lockup_allowed        = false;
transmission.torque_converter.lockup_duration_secs  = 0;

% Define Torque Converter Inertia Values (Class 6 vocational truck)
transmission.torque_converter.pump_inertia_kgm2     = 0;
transmission.torque_converter.turbine_inertia_kgm2  = 0;

% Define Torque Converter Data 
transmission.torque_converter.calcs.all_speed_ratios = linspace(0,1,250);
transmission.torque_converter.calcs.all_torque_ratios = zeros( 250,1 );
transmission.torque_converter.calcs.all_k_factors_rpmpsqrtNm = zeros( 250,1 );

%transmission.torque_converter.decel_k_factor = transmission.torque_converter.decel_k_factor ./ sqrt(transmission.torque_converter.decel_torque_ratio) .* transmission.torque_converter.spd_ratio;

% ... pump loss
transmission.gear.pump_loss_engine_speed_radps  = linspace(0,eps,DIM);%
transmission.gear.pump_loss_torque_Nm           = zeros(size(transmission.gear.pump_loss_engine_speed_radps));

% Define Gear Characteristics
transmission.gear.number =				0:1:99; %zeros(1,DIM); % [0:(DIM-1)];
transmission.gear.ratio  =				zeros(size(transmission.gear.number));
transmission.gear.inertia_kgm2 =		zeros(size(transmission.gear.number));
transmission.gear.efficiency_norm =		zeros(size(transmission.gear.number));
transmission.gear.torque_limit_Nm =		zeros(size(transmission.gear.number));

transmission.gear.common_input_inertia_kgm2  = 0;
transmission.gear.common_output_inertia_kgm2 = 0;
transmission.gear.disable_dynamic_ratio = false;

% spin loss
transmission.gear.spin_loss_speed_radps =	linspace(0,eps,DIM);			
transmission.gear.spin_loss_torque_Nm = zeros(length(transmission.gear.number),length(transmission.gear.spin_loss_speed_radps) );

transmission.torque_converter.lockup_speed_source = enum_speed_source.gearbox_input_rpm;
transmission.torque_converter.lockup_load_source = enum_load_source.driver_acl_pct;

% Define Torque Converter Lock-Up Schedule(2b-5 vocational truck)
% ... lock-up schedule (transmission output speed in RPM)
transmission.torque_converter.lock_map_load =	linspace(0,eps,DIM);			
transmission.torque_converter.lock_map_speed = zeros( length(transmission.torque_converter.lock_map_load), length(transmission.gear.number)-1 );

% ... release schedule (transmission output speed in RPM)
transmission.torque_converter.unlock_map_load = linspace(0,eps,DIM);
transmission.torque_converter.unlock_map_speed = zeros(length(transmission.torque_converter.unlock_map_load), length(transmission.gear.number)-1 );



