%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameter Initialization for Vehicle System
% - This file initializes model parameters of Vehicle System for GEM.
%
% - Created by James Sanchez & Lisandro Quinones
%   Edited by Byungho Lee
%   Modified by Houshun Zhang
%
% - Assessment & Standards Division
%   Office of Transportation & Air Quality
%   US Environmental Protection Agency
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if exist('REVS','var') && REVS.verbose  disp(['Loading Vehicle Parameters for Executable Generation']); end

vehicle_driveline_type = enum_driveline_type.one_axle_drive;
vehicle_powertrain_type = enum_powertrain_type.conventional;

vehicle.max_wheel_torque_Nm = 0;
vehicle.max_wheel_torque_curve_Nm = zeros(1,100);
vehicle.max_wheel_torque_curve_speed_mps = linspace(0,eps,100);


%% Define Drive Shaft Inertia & Efficiency
vehicle.driveshaft.inertia_kgm2          = 0.0;
vehicle.driveshaft.efficiency_norm       = 0.00;

 
%% Define Final Drive Ratio
vehicle.drive_axle1.final_drive.gear_ratio             = 0;


%% Define Final Drive Inertia & Efficiency
vehicle.drive_axle1.final_drive.inertia_kgm2      = 0;
vehicle.drive_axle1.final_drive.efficiency_norm               = 0;


%% Define Brake Parameters
vehicle.drive_axle1.brake.proportion_norm           = 1;
vehicle.drive_axle1.brake.max_torque_Nm             = 0;
vehicle.drive_axle1.brake.inertia_kgm2              = 0; % 80;
vehicle.max_brake_torque_Nm = 0;

%% Define Loaded Tire Parameters
%Adjusted to Match Engine Speeds on Steady State Cycles
vehicle.drive_axle1.tire.radius_m         = 0;
vehicle.drive_axle1.tire.vehicle_weight_norm      = 1;
vehicle.drive_axle1.tire.inertia_kgm2     = 0; % 0;


%% Define Total Mass of Vehicle (kg) & Frontal Area of Vehicle (m^2)
vehicle.mass_static_kg          = 0;  % was 33130;
vehicle.mass_dynamic_kg         = 0;   % rotating inertia handled in axles inertias
vehicle.frontal_area_m2         = 0;
vehicle.aerodynamic_drag_coeff               = 0; 

%% Define Tire Rolling Resistance (kg/ton)

%Derived from Coastdown A Term
vehicle.drive_axle1.tire.rolling_resistance_coefficient        = 0;


%% Raw Coastdoen ABCs
vehicle.use_abc_roadload = false;
vehicle.coastdown_A_N              = 0;   % from SWRI
vehicle.coastdown_B_Npms           = 0;	  % from SWRI
vehicle.coastdown_C_Npms2          = 0;  % from SWRI

% Define Vehicle Payload (ton) and Weight Reducition (lb)
vehicle.payload_ton = 0.0;
vehicle.speed_limit_mps = 299792458;

