function [ rounded_number ] = ASTM_round( var , precision)
% Rounds numbers as defined in ISO/IEC/IEEE 60559
% usage: ASTM_round(var) where var is a scalar or vector
    
	if nargin < 2
		precision = 0;
	end

	var = var * (10^precision);
	z = rem(var,2);
    z(abs(z) ~= 0.5) = 0;
    rounded_number = round(var - z) ./ (10^precision);
end
