function [ revs_data ] = REVS_CVM_renamalyzer( vehicle, engine, transmission, audit, datalog )
% function [ revs_data ] = REVS_CVM_renamalyzer( audit, datalog )
%   stores raw model outputs in REVS class_test_data for comparison with test
%   data in the same format, for example

revs_data = class_test_data(datalog.time);

revs_data.vehicle.mass_static_kg            = vehicle.mass_static_kg;
revs_data.vehicle.mass_dynamic_kg           = vehicle.mass_dynamic_kg;

if isprop(revs_data.vehicle,'coastdown_A_N')
    revs_data.vehicle.coastdown_A_N             = vehicle.coastdown_A_N;
    revs_data.vehicle.coastdown_B_Npms          = vehicle.coastdown_B_Npms;
    revs_data.vehicle.coastdown_C_Npms2         = vehicle.coastdown_C_Npms2;
end

revs_data.vehicle.tire_rolling_radius_m     = vehicle.drive_axle1.tire.radius_m;
revs_data.vehicle.accel_pedal_norm          = datalog.driver.accel_norm;
revs_data.vehicle.brake_pedal_norm          = datalog.driver.brake_norm;
revs_data.vehicle.drive_cycle_speed_mps     = datalog.drive_cycle_speed_mps;
revs_data.vehicle.drive_cycle_phase         = datalog.drive_cycle_phase;
revs_data.vehicle.drive_cycle_time          = datalog.time;
revs_data.vehicle.dyno_speed_mps            = audit.mech.vehicle.output_mps;
revs_data.vehicle.dyno_distance_m           = audit.mech.vehicle.output_m;
try % GEM -v,3 fix
    revs_data.vehicle.dyno_tractive_force_N     = audit.mech.vehicle.input_N;
end
revs_data.vehicle.final_drive_ratio         = vehicle.drive_axle1.final_drive.gear_ratio;
revs_data.vehicle.speed_mps                 = audit.mech.vehicle.output_mps; % was audit.mech.drive_axle1.tire.input_radps * revs_data.vehicle.tire_rolling_radius_m;
%revs_data.vehicle.distance_m                = audit.mech.drive_axle1.tire.output_m;
revs_data.vehicle.wheel_torque_Nm           = audit.mech.drive_axle1.tire.input_Nm;
revs_data.vehicle.halfshaft_torque_Nm       = audit.mech.drive_axle1.tire.input_Nm;
% revs_data.vehicle.fuel.type                 = vehicle.fuel_type; % Not present in REVS 2 (?)

if ~isempty( vehicle.fuel)
	revs_data.vehicle.fuel.density_kgpL_15C     = vehicle.fuel.density_kgpL_15C;
	revs_data.vehicle.fuel.energy_density_MJpkg = vehicle.fuel.energy_density_MJpkg;
else
	revs_data.vehicle.fuel.density_kgpL_15C     = engine.fuel.density_kgpL_15C;
	revs_data.vehicle.fuel.energy_density_MJpkg = engine.fuel.energy_density_MJpkg;
end

revs_data.vehicle.fuel.flow_rate_gps        = datalog.engine.fuel_rate_gps;
revs_data.vehicle.fuel.mass_g               = datalog.engine.fuel_consumed_g;

revs_data.engine.speed_radps                = audit.mech.engine.crankshaft_radps;
revs_data.engine.gross_torque_Nm            = audit.mech.engine.crankshaft_gross_Nm;
revs_data.engine.crankshaft_torque_Nm       = audit.mech.engine.crankshaft_Nm;
revs_data.engine.load_at_current_speed_norm = datalog.engine.load_norm;
revs_data.engine.gross_power_kW             = audit.mech.engine.crankshaft_gross_kW;
revs_data.engine.crankshaft_power_kW        = audit.mech.engine.crankshaft_kW;
% revs_data.engine.fuel.type                  = engine.fuel_type; % Not present in REVS 2 (?)
try % GEM -v,3 fix
    revs_data.engine.fuel.density_kgpL_15C      = engine.fuel.density_kgpL_15C;
end
revs_data.engine.fuel.energy_density_MJpkg  = engine.fuel.energy_density_MJpkg;
revs_data.engine.fuel.flow_rate_gps         = datalog.engine.fuel_rate_gps;
revs_data.engine.fuel.mass_g                = datalog.engine.fuel_consumed_g;

revs_data.transmission.type                         = evalin('caller','transmission_type');
revs_data.transmission.gear_ratios                  = transmission.gear.ratio;
revs_data.transmission.current_gear_number          = datalog.transmission.current_gear;
revs_data.transmission.commanded_gear_number        = datalog.transmission.selected_gear_num;
revs_data.transmission.output_torque_Nm             = datalog.transmission.output_torque_Nm; % Logan

if revs_data.transmission.type == enum_transmission_type.DCT
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox1.input_Nm + audit.mech.gearbox2.input_Nm;
else
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox.input_Nm;
end

if revs_data.transmission.type == enum_transmission_type.automatic
    revs_data.transmission.launch_device_lockup_norm    = datalog.torque_converter.tcc_engage_norm;
elseif revs_data.transmission.type == enum_transmission_type.CVT
    revs_data.transmission.launch_device_lockup_norm    = datalog.torque_converter.tcc_engage_norm;    
     % other trans types here
end

if revs_data.transmission.type == enum_transmission_type.CVT
    revs_data.transmission.current_CVT_ratio        = min(max(transmission.gear.ratio), datalog.gearbox.actual_ratio .* (datalog.gearbox.engage_norm > 0));
elseif revs_data.transmission.type == enum_transmission_type.DCT    
    odd_pts     = datalog.transmission.clutch1_engage ~= 0;
    even_pts    = datalog.transmission.clutch1_engage ~= 0;
    
    temp.transmission_current_gear_ratio                    = zeros(size(revs_data.time));
    temp.transmission_current_gear_ratio(odd_pts)           = datalog.gearbox1.actual_ratio(odd_pts);
    temp.transmission_current_gear_ratio(even_pts)          = datalog.gearbox2.actual_ratio(even_pts);
    revs_data.transmission.current_gear_ratio               = temp.transmission_current_gear_ratio;
    
    temp.transmission.gearbox_input_speed_radps             = zeros(size(revs_data.time));
    temp.transmission.gearbox_input_speed_radps(odd_pts)    = audit.mech.gearbox1.input_radps(odd_pts);
    temp.transmission.gearbox_input_speed_radps(even_pts)   = audit.mech.gearbox2.input_radps(even_pts);
    revs_data.transmission.gearbox_input_speed_radps        = temp.transmission.gearbox_input_speed_radps;
else
    try % GEM -v,3 fix
        revs_data.transmission.current_gear_ratio       = datalog.gearbox.actual_ratio;
    end
end

if revs_data.transmission.type == enum_transmission_type.DCT
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.dual_clutch.input_Nm;
    revs_data.transmission.output_torque_Nm             = datalog.transmission.output_torque_Nm;    
    revs_data.transmission.gearbox_output_speed_radps   = audit.mech.gearbox1.output_radps;
else
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox.input_Nm;
    revs_data.transmission.output_torque_Nm             = audit.mech.gearbox.output_Nm;    
    revs_data.transmission.gearbox_input_speed_radps    = audit.mech.gearbox.input_radps;
    revs_data.transmission.gearbox_output_speed_radps   = audit.mech.gearbox.output_radps;
end

if isfield(datalog.transmission,'temperature_degC')
    revs_data.transmission.oil_temp_degC            = datalog.transmission.temperature_degC;
end

if isfield(datalog, 'transmission.command_line_pressure_bar')
    revs_data.transmission.line_pressure_bar            = datalog.transmission.command_line_pressure_bar;
end

try % GEM -v,3 fix
    revs_data.accessory.alternator_A                    = audit.elec.alternator.input_Amps;
    revs_data.accessory.alternator_V                    = audit.elec.alternator.input_Volts;
    revs_data.accessory.alternator_electrical_kW        = audit.elec.alternator.input_kW;
    revs_data.accessory.alternator_speed_radps          = audit.mech.alternator.output_radps;
    revs_data.accessory.alternator_torque_Nm            = audit.mech.alternator.output_Nm;
    revs_data.accessory.alternator_mechanical_kW        = audit.mech.alternator.output_kW;
    revs_data.accessory.battery_A                       = audit.elec.battery_Amps;
    revs_data.accessory.battery_V                       = audit.elec.battery_Volts;
    revs_data.accessory.battery_SoC_norm                = audit.elec.battery_SoC_norm;    
    revs_data.accessory.battery_kW                      = audit.elec.battery_kW;
    revs_data.accessory.torque_Nm                       = audit.mech.engine.accessories_Nm;
    revs_data.accessory.speed_radps                     = audit.mech.engine.accessories_radps;
    revs_data.accessory.mechanical_kW                   = audit.mech.engine.accessories_kW;
end
end