%function [] = powerlines(min_rpm, max_rpm, mintorque_Nm, maxtorque_Nm, varargin)
% draws lines of constant power from 5kw to max kW increments
%   optional arguments (varargin)
%   'max_kw',N [default corner kW] :   max power line = N
%   'z_offset',N [default 0]       :   power line z offset = N
%   'increment',N [default 10]     :   increment between power lines in kW

function [] = powerlines(min_rpm, max_rpm, mintorque_Nm, maxtorque_Nm, varargin)

    max_kW      = parse_varargs(varargin, 'max_kw', max_rpm * maxtorque_Nm / 9549.3, 'numeric');
    z_offset    = parse_varargs(varargin, 'z_offset', 0, 'numeric');
    increment    = parse_varargs(varargin, 'increment', 10, 'numeric');

    hold_status = ishold;
    
    %hold on;

    set(gca, 'DrawMode', 'fast');

    min_rpm = max(eps, min_rpm);

    x = linspace(min_rpm, max_rpm, 25);
    for power = [increment/2, increment:increment:max_kW];
        torques = power./x/1.047e-4;
        pts = find(torques<maxtorque_Nm & torques>mintorque_Nm);
        if ~isempty(pts)
            h = line(x, torques, zeros(size(x)) + z_offset);
            set(h, 'color','k');
            
            text(x(pts(end)), torques(pts(end)), z_offset, [' ' num2str(power) ' kW']);
        end;
    end;

   % hold(hold_status);
end