engine_map.speed_size = 50;
engine_map.torque_size = 50;

engine_map.speed_rpm = fuel_map_speed_rpm;
engine_map.torque_Nm = fuel_map_torque_Nm;
engine_map.fuel_rate_gps = fuel_map_rate_gps;

engine_map.closed_throttle_speed_rpm = min_torque_speed_rpm;
engine_map.closed_throttle_torque_Nm = min_torque_Nm;

engine_map.speed_rpm = [engine_map.speed_rpm; engine_map.closed_throttle_speed_rpm];
engine_map.torque_Nm = [engine_map.torque_Nm; engine_map.closed_throttle_torque_Nm];
engine_map.fuel_rate_gps = [engine_map.fuel_rate_gps; zeros(size(engine_map.closed_throttle_speed_rpm))];

engine_map.min_speed_rpm = 0;
engine_map.max_speed_rpm = max(engine_map.speed_rpm) * 1.1;
engine_map.min_torque_Nm = min(0, min(engine_map.torque_Nm) * 1.1);
engine_map.max_torque_Nm = max(max(engine_map.torque_Nm), max(max_torque_Nm)) * 1.1;

engine_map.fuel_map_speed_rpm = linspace(engine_map.min_speed_rpm, engine_map.max_speed_rpm, engine_map.speed_size);
engine_map.fuel_map_torque_Nm = linspace(engine_map.min_torque_Nm, engine_map.max_torque_Nm, engine_map.torque_size);

first_fit = max(0, scatter2surf(engine_map.speed_rpm, engine_map.torque_Nm, engine_map.fuel_rate_gps, engine_map.fuel_map_speed_rpm, engine_map.fuel_map_torque_Nm,'method','gridfit','surf','xnormalize','ynormalize')); title(['First Fit ' engine_map.name]);
%first_fit = max(0, scatter2surf(engine_map.speed_rpm, engine_map.torque_Nm, engine_map.fuel_rate_gps, engine_map.fuel_map_speed_rpm, engine_map.fuel_map_torque_Nm,'method','gridfit'));

% find the corners to add to the raw data for regular TriScatteredInterp:
engine_map.lower_right = first_fit(1,end);
engine_map.upper_right = first_fit(end,end);
engine_map.upper_left = max(first_fit(end,1), 0.1*engine_map.upper_right);
engine_map.lower_left = first_fit(1,1);

engine_map.speed_rpm = [engine_map.speed_rpm; engine_map.min_speed_rpm; engine_map.min_speed_rpm; engine_map.max_speed_rpm; engine_map.max_speed_rpm];
engine_map.torque_Nm = [engine_map.torque_Nm; engine_map.min_torque_Nm; engine_map.max_torque_Nm; engine_map.min_torque_Nm; engine_map.max_torque_Nm];
engine_map.fuel_rate_gps = [engine_map.fuel_rate_gps; engine_map.lower_left; engine_map.upper_left; engine_map.lower_right; engine_map.upper_right];

%% 
new_engine.full_throttle_speed_radps = [0 max_torque_speed_rpm' (max_torque_speed_rpm(end)+1)] * convert.rpm2radps;
new_engine.full_throttle_torque_Nm = [0 max_torque_Nm' 0];

new_engine.closed_throttle_speed_radps = min_torque_speed_rpm' * convert.rpm2radps;
new_engine.closed_throttle_torque_Nm = min_torque_Nm';

new_engine.fuel_map_speed_radps   = engine_map.fuel_map_speed_rpm' * convert.rpm2radps;
new_engine.fuel_map_torque_Nm     = engine_map.fuel_map_torque_Nm';

new_engine.fuel_map_gps =  scatter2surf(engine_map.speed_rpm, engine_map.torque_Nm, engine_map.fuel_rate_gps, engine_map.fuel_map_speed_rpm,engine_map.fuel_map_torque_Nm,'surf','xnormalize','ynormalize'); title(['Final Fit ' engine_map.name]);
%engine.fuel_map_gps =  scatter2surf(engine_map.speed_rpm, engine_map.torque_Nm, engine_map.fuel_rate_gps, engine_map.fuel_map_speed_rpm,engine_map.fuel_map_torque_Nm);

% clear first_fit engine_map;
