function [result, datalog] = run_common_CVM_HVM_postproc_func(REVS, REVS_current_model_type, drive_cycle, time, engine, vehicle, audit, datalog)


% Compute Additional Engine Fuel Information
    

	% Base fuel to volume and CO2 equivalent
	datalog.engine.fuel_rate_Lps			= datalog.engine.fuel_rate_gps /( 1000 * engine.fuel.density_kgpL_15C );
	datalog.engine.fuel_rate_galps			= datalog.engine.fuel_rate_Lps * convert.lit2gal;
	datalog.engine.fuel_gCO2ps				= datalog.engine.fuel_rate_galps * engine.fuel.gCO2pgal;
	
	
    datalog.engine.fuel_consumed_L			= datalog.engine.fuel_consumed_g / ( 1000 * engine.fuel.density_kgpL_15C );
	datalog.engine.fuel_consumed_gallons	= datalog.engine.fuel_consumed_L * convert.lit2gal;
	datalog.engine.fuel_gCO2				= datalog.engine.fuel_consumed_gallons * engine.fuel.gCO2pgal;
	
	
	% Convert to "vehicle" fuel if provided otherwise copy engine
	if isfield(vehicle,'fuel') && ~isempty( vehicle.fuel)
		
		datalog.vehicle.fuel_consumed_g			= datalog.engine.fuel_consumed_g * engine.fuel.energy_density_MJpkg / vehicle.fuel.energy_density_MJpkg;
		datalog.vehicle.fuel_rate_gps			= datalog.engine.fuel_rate_gps * engine.fuel.energy_density_MJpkg / vehicle.fuel.energy_density_MJpkg;
		
		
		datalog.vehicle.fuel_rate_Lps			= datalog.vehicle.fuel_rate_gps /(  1000 * vehicle.fuel.density_kgpL_15C);
		datalog.vehicle.fuel_rate_galps			= datalog.vehicle.fuel_rate_Lps * convert.lit2gal;
		datalog.vehicle.fuel_gCO2ps				= datalog.vehicle.fuel_rate_galps * vehicle.fuel.gCO2pgal;


		datalog.vehicle.fuel_consumed_L			= datalog.vehicle.fuel_consumed_g /( 1000 / vehicle.fuel.density_kgpL_15C);
		datalog.vehicle.fuel_consumed_gallons	= datalog.vehicle.fuel_consumed_L * convert.lit2gal;
		datalog.vehicle.fuel_gCO2				= datalog.vehicle.fuel_consumed_gallons * vehicle.fuel.gCO2pgal;
		
		
	else
		
		
		datalog.vehicle.fuel_consumed_g			= datalog.engine.fuel_consumed_g;
		datalog.vehicle.fuel_rate_gps			= datalog.engine.fuel_rate_gps;
		
		datalog.vehicle.fuel_rate_Lps			= datalog.engine.fuel_rate_Lps;
		datalog.vehicle.fuel_rate_galps			= datalog.engine.fuel_rate_galps;
		datalog.vehicle.fuel_gCO2ps				= datalog.engine.fuel_gCO2ps;
	
	
		datalog.vehicle.fuel_consumed_L			= datalog.engine.fuel_consumed_L;
		datalog.vehicle.fuel_consumed_gallons	= datalog.engine.fuel_consumed_gallons;
		datalog.vehicle.fuel_gCO2				= datalog.engine.fuel_gCO2;
		
	end


%% Calculate Total Cycle Results
result.cycle_name = drive_cycle.name;

% ... calculate percent time trace missed by 2mph (%) 
vehicle_speed_error_mph     = (datalog.drive_cycle_speed_mps - datalog.vehicle.speed_mps) * convert.mps2mph;
datalog.vehicle.distance_mi = datalog.vehicle.distance_m / convert.mi2mtr;
result.cycle_error_time_pct = integrate((vehicle_speed_error_mph >= 2), time, 1) / time(end) * 100;
result.distance_mi          = datalog.vehicle.distance_mi(end);

% ... calculate total fuel consumption (mpg)
result.fuel_g       = datalog.vehicle.fuel_consumed_g(end);
result.fuel_gallons = datalog.vehicle.fuel_consumed_gallons(end) ;
result.FE_mpg       = datalog.vehicle.distance_mi(end) / datalog.vehicle.fuel_consumed_gallons(end); 
result.gCO2         = datalog.vehicle.fuel_gCO2(end);
result.gCO2pmi      = result.gCO2 / datalog.vehicle.distance_mi(end);

% GEM specific results
if isfield(vehicle,'payload_ton') && ~is_unspecified(vehicle.payload_ton)
    result.gCO2ptm =  result.gCO2pmi / vehicle.payload_ton;
end

try 

% Signals from audit
if exist('audit','var')
    result.engine_output_energy_kJ = audit.mech.engine.crankshaft_gross_kJ(end);
end

end
%% Calculate Phase Results

for p = 1:max(datalog.drive_cycle_phase)

    start_idx = find(datalog.drive_cycle_phase == p);
    start_idx = setdiff( start_idx, start_idx+1 );

    end_idx = find(datalog.drive_cycle_phase == p);
    end_idx = setdiff( end_idx, end_idx-1 );

    result.phase_time_secs(p)       = sum(time(end_idx) - time(start_idx));
    result.phase_distance_mi(p)     = sum( datalog.vehicle.distance_mi(end_idx))  - sum( datalog.vehicle.distance_mi(start_idx));
    result.phase_distance_m(p)      = sum( datalog.vehicle.distance_m(end_idx))  - sum( datalog.vehicle.distance_m(start_idx));
    result.idle_time_secs(p)        = integrate(datalog.vehicle.speed_mps(start_idx:end_idx) < 0.1, time(start_idx:end_idx), 1);
    result.phase_avg_speed_mph(p)   = result.phase_distance_mi(p)/(result.phase_time_secs(p) - result.idle_time_secs(p))*3600;
    result.phase_avg_speed_mps(p)   = result.phase_distance_m(p)/(result.phase_time_secs(p) - result.idle_time_secs(p));
	result.phase_fuel_g(p)          = sum( datalog.vehicle.fuel_consumed_g(end_idx)) - sum( datalog.engine.fuel_consumed_g(start_idx));
    result.phase_fuel_gallons(p)    = sum( datalog.vehicle.fuel_consumed_gallons(end_idx)) - sum( datalog.vehicle.fuel_consumed_gallons(start_idx));
    result.phase_gCO2(p)            = sum( datalog.vehicle.fuel_gCO2(end_idx)) - sum( datalog.vehicle.fuel_gCO2(start_idx));
    result.phase_gCO2pmi(p)         = result.phase_gCO2(p) / result.phase_distance_mi(p);
    result.phase_FE_mpg(p)          = result.phase_distance_mi(p) / result.phase_fuel_gallons(p);
    
% 	try
%        result.phase_N_rpm(p)           = integrate(datalog.engine.crankshaft_gross_speed_radps * convert.radps2rpm .* (datalog.drive_cycle_phase == p), time, 1)/result.phase_time_secs(p);
%        result.phase_NV_ratio(p)        = result.phase_N_rpm(p) / 60 / result.phase_avg_speed_mps(p);

        result.phase_NV_ratio(p)    = vehicle.drive_axle1.final_drive.gear_ratio / (2 * pi * vehicle.drive_axle1.tire.radius_m);
        
        [~, corrected_power_W] = REVS_calc_corrected_torque_and_power(time, datalog.engine.crankshaft_gross_torque_Nm, datalog.engine.crankshaft_speed_radps, datalog.engine.crankshaft_gross_inertia_kgm2);
%        result.phase_crankshaft_pos_work_hphr(p) = integrate(max(0, corrected_power_W / 1000 * convert.kW2hp) .* (datalog.drive_cycle_phase == p), time / 3600, 1);
        result.phase_crankshaft_pos_work_kWh(p) = integrate(max(0, corrected_power_W / 1000) .* (datalog.drive_cycle_phase == p), time / 3600, 1);

        [~, corrected_power_W] = REVS_calc_corrected_torque_and_power(time, datalog.transmission.output_torque_Nm, datalog.transmission.output_speed_radps, datalog.transmission.output_inertia_kgm2);
%        result.phase_powertrain_pos_work_hphr(p) = integrate(max(0, corrected_power_W / 1000 * convert.kW2hp) .* (datalog.drive_cycle_phase == p), time / 3600, 1);
        result.phase_transmission_pos_work_kWh(p) = integrate(max(0, corrected_power_W / 1000) .* (datalog.drive_cycle_phase == p), time / 3600, 1);

        [~, corrected_power_W] = REVS_calc_corrected_torque_and_power(time, datalog.final_drive.output_torque_Nm, datalog.final_drive.output_speed_radps, datalog.final_drive.output_inertia_kgm2);
%        result.phase_final_drive_pos_work_hphr(p) = integrate(max(0, corrected_power_W / 1000 * convert.kW2hp) .* (datalog.drive_cycle_phase == p), time / 3600, 1);
        result.phase_final_drive_pos_work_kWh(p) = integrate(max(0, corrected_power_W / 1000) .* (datalog.drive_cycle_phase == p), time / 3600, 1);

        clear corrected_power_W;

        if exist('audit','var')
            result.phase_engine_output_energy_kJ = sum( audit.mech.engine.crankshaft_gross_kJ(end_idx))  - sum( audit.mech.engine.crankshaft_gross_kJ(start_idx));
        end
	end
   
%     if isfield(vehicle,'payload_ton') && ~is_unspecified(vehicle.payload_ton)
%         result.phase_gCO2ptmi(p) = result.phase_gCO2pmi(p) / vehicle.payload_ton;
%     end
% end

%% Display Post-Processing Results\
if REVS.verbose
    % ... display percent time trace missed by 2mph (%)
    fprintf(1,'\n-- Summary data for %s drive cycle --\n\n',    drive_cycle.name);
    fprintf(1,'   Percent Time Missed by 2mph   = %6.2f %%\n',  result.cycle_error_time_pct)

    for p = 1:max(datalog.drive_cycle_phase)
        if max(datalog.drive_cycle_phase) ~= min(datalog.drive_cycle_phase)
            fprintf(1,'   Phase %d -------------------------------\n',p);
            if isfield(drive_cycle, 'phase_name');
                fprintf(1,'   >> %s\n',drive_cycle.phase_name{p});
            end
            fprintf(1,'   Distance            = %6.3f mi\n',        result.phase_distance_mi(p));
            fprintf(1,'   Fuel Consumption    = %6.4f gallons\n',   result.phase_fuel_gallons(p));
            fprintf(1,'   Fuel Consumption    = %6.4f grams\n',     result.phase_fuel_g(p));
            fprintf(1,'   Fuel Economy        = %6.3f mpg\n',       result.phase_FE_mpg(p));
            fprintf(1,'   Fuel Consumption    = %6.3f g/mile\n',    result.phase_fuel_g(p) / result.phase_distance_mi(p));
            fprintf(1,'   CO2 Emission        = %6.2f g/mile\n',    result.phase_gCO2pmi(p));

            if isfield(vehicle,'payload_ton') && ~is_unspecified(vehicle.payload_ton)
                fprintf(1,'   CO2 Emission (Phase %d)         = %6.2f g/ton-mile\n', p, result.phase_gCO2ptmi(p));
            end
            fprintf(1,'\n');
        end
    end

    % Print Total Results
    fprintf(1,'   Total ----------------------------------\n');
    fprintf(1,'   >> %s\n', drive_cycle.name);
    fprintf(1,'   Distance            = %6.3f mi\n', datalog.vehicle.distance_mi(end));
    fprintf(1,'   Fuel Consumption    = %6.4f gallons\n', datalog.vehicle.fuel_consumed_gallons(end));
    fprintf(1,'   Fuel Consumption    = %6.4f grams\n', datalog.engine.fuel_consumed_g(end));
    fprintf(1,'   Fuel Economy        = %6.3f mpg\n', result.FE_mpg)
    fprintf(1,'   Fuel Consumption    = %6.3f g/mile\n', datalog.engine.fuel_consumed_g(end) / datalog.vehicle.distance_mi(end));
    fprintf(1,'   CO2 Emission        = %6.2f g/mile\n', result.gCO2pmi)

    if isfield(vehicle,'payload_ton') && ~is_unspecified(vehicle.payload_ton)
        fprintf(1,'   CO2 Emission (Total)          = %6.2f g/ton-mile\n', result.gCO2ptm);
    end
end

% Run Shift Statistics if Transmission Data
if isfield(datalog,'transmission')
    result = run_shift_stats_func(REVS.verbose, datalog, result);
end


%% cleanup
clear gCO2pgal start_idx end_idx p meters_per_kg_fuel vehicle_speed_error_mph pts;
