classdef class_REVS_clutch
    %class_REVS_clutch
    %   Definition of class_REVS_clutch class
    
    properties
        
        input_inertia_kgm2  = 0.0;	% Rotational Inertia of Input Shaft kgm^2
        output_inertia_kgm2 = 0.0;	% Rotational Inertia of Output Shaft kgm^2
        
        engage_duration_secs = 0.2;	% Clutch engagement minimum duration - used as rate limiter when shifting [secs]
        
        torque_capacity_Nm;			% Maximum torque transfer avaialble via clutch
        
        input_torque_loss_Nm@class_REVS_dynamic_lookup;		% Torque Loss applied at input {Dynamic Lookup]
        
    end
    
    properties ( Dependent = true, SetAccess = private, Transient = true)
        
    end
    
    
    methods
        
        function obj = class_REVS_clutch(engine)
            
            obj.input_torque_loss_Nm = class_REVS_dynamic_lookup;
            
            
            if nargin >= 1        
                obj.torque_capacity_Nm = 1.8 * engine.max_torque_Nm;
            end
            
            
        end

        %TODO Add getter for 0 default input torque loss
        
    end
    
end
