classdef class_REVS_dynamic_lookup < matlab.mixin.CustomDisplay
	%UNTITLED2 Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		table@double;
		axis_1 = class_REVS_dynamic_lookup_axis;
		axis_2 = class_REVS_dynamic_lookup_axis;
		axis_3 = class_REVS_dynamic_lookup_axis;
		axis_4 = class_REVS_dynamic_lookup_axis;
		axis_5 = class_REVS_dynamic_lookup_axis;
		axis_6 = class_REVS_dynamic_lookup_axis;
		axis_7 = class_REVS_dynamic_lookup_axis;
		axis_8 = class_REVS_dynamic_lookup_axis;
		axis_9 = class_REVS_dynamic_lookup_axis;
		axis_10 = class_REVS_dynamic_lookup_axis;
		interp_method = 'linear';
	end
			
	properties (Dependent = true)
		table_size@uint32;
    end
		
   
    
	methods
        function val = isempty(obj)
            val = isempty(obj.table) && isempty(obj.axis_1.signal) && isempty(obj.axis_1.breakpoints);
        end
        
		function val = get.table_size(obj)
			val = size(obj.table) - 1;
			val = uint32(val(val > 0));
		end		
				
% 		function obj = set.interp_method(obj,val)
% 			opts = {'flat','linear','spline'};
% 			obj.interp_method = validatestring(val,opts);		
% 		end
				
	end	
	
	methods ( Access = protected)
		
		% Select properties for display
		function val = getPropertyGroups(obj)
						val = matlab.mixin.util.PropertyGroup(obj.show_active_fields);
		end		
		
		% Determine which fields are used for display & 
		function val = show_active_fields(obj)
			
			val = {'axis_1'};
			
			for a = 2:10
				axis_str = ['axis_',int2str(a)];
				
				if ~isempty(obj.(axis_str)) && (length(obj.table_size) >= a || ~isempty( obj.(axis_str).signal) || ~isempty( obj.(axis_str).breakpoints ) )
					val{end+1,1} = axis_str;
				end
				
			end
			val{end+1,1} = 'table';
			val{end+1,1} = 'interp_method';
			val{end+1,1} = 'table_size';
			
		end
		
	end

	methods( Hidden = true )
		
		% Override fieldnames only showing desired fields
		function val = fieldnames(obj)
			val = obj.show_active_fields;
		end
			
		% Override fieldnames only showing desired fields
		function val = properties(obj)
			val = obj.show_active_fields;
		end
	end
	
end

