classdef class_REVS_sim_case < handle
	%UNTITLED Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		
		
		model = 'REVS_VM';
		params = class_REVS_sim_params;
		drive_cycle;
	
		external_data_index;
		use_driven_trace;
		use_external_shift;
		use_external_lockup;
		
		sim_step_time = 0.01;
		sim_start_time_secs = -5;
		
		global_decimation = 1;
		verbose = 0;
		
		result = {};
		audit = {};						% Array for storage of output audit data
		datalog = {};					% Array 
		
		model_data = {};				% Array for storage of output model data as class_test_data objects
		
		test_data = {};					% Optional array of class_test_data objects - Used to provide external data and for post simulation analysis 
		
		
	end
	
	methods
		
		function sim(obj)
			
			obj.load_workspace;
			
			if isempty(obj.test_data)
				ext_idx = 1;
			elseif isempty(obj.external_data_index) || strcmpi( obj.external_data_index, 'ALL')
				ext_idx = 1:numel( obj.test_data);
			else
				ext_idx = obj.external_data_index;
			end
				
			
			
			for i = ext_idx
			
			if obj.use_driven_trace
				drive_cycle = evalin('base','drive_cycle');
				drive_cycle.cycle_time = obj.test_data(i).dyno_speed_mps;
				drive_cycle.cycle_speed_mps = obj.test_data(i).vehicle.dyno_speed_mps;
				assignin('base','drive_cycle',drive_cycle ); 
			end
				

			evalin('base',['sim ',obj.model,' ;']);
			evalin('base','run_cycle_postproc;');
			
			
			% Store Results
				obj.result{i}  = evalin('base','result');


			if obj.verbose >= 0 
				obj.datalog{i} = evalin('base','datalog');
				obj.model_data{i} = evalin('base','model_data');
			end
			
			if obj.verbose >= 1
				obj.audit{i} = evalin('base','audit');
			end
			
			end
			
			
		end
		
		function load_workspace( obj )
			
			% Load Configuration Structure
			REVS.current_model = obj.model;
			REVS.model_architecture = 'REVS_CVM';

			REVS.sim_step_time_secs = obj.sim_step_time;
			REVS.sim_start_time_secs = obj.sim_start_time_secs; 

			REVS.verbose = obj.verbose;
			REVS.global_decimation = obj.global_decimation;

			assignin('base','REVS',REVS);

			% Load Param Files
			obj.params.load();
			

			% Load Drive Cycle
			if ischar( obj.drive_cycle )
				evalin('base',['load ',obj.drive_cycle,' ;']);
			else
				assignin('base','drive_cycle' , obj.drive_cycle);
			end
			
		end
		
		
		
	end
	
end

