classdef class_REVS_sim_params
	%CLASS_REVS_SIM_PARAMS 
	%	Stores parameter information for a REVS2 vehicle simulation. Parameter
	%	information can be stored directly in the struct or by a string or 
	%	cell array of strings pointing to peremeter definition files that 
	%	will be called via the run command.
	
	properties
		engine_param;
		transmission_param;
		vehicle_param;
		electric_param;
		accessory_param;
		controls_param;
		driver_param;
		ambient_param;
	end
	
	methods
		
		function load( obj, ws)
			
			if nargin < 2
				ws = 'base';
			end
				
			
			% engine
			if ischar( obj.engine_param )			
				evalin(ws,['run(''',obj.engine_param,''');']);
			elseif iscell( obj.engine_param )	
				for p = 1:numel( obj.engine_param )
					evalin(ws,['run(''',obj.engine_param{p},''');']);
				end
			else
				assignin(ws,'engine', obj.engine_param);
			end
			
			% transmission
			if ischar( obj.transmission_param )			
				evalin(ws,['run(''',obj.transmission_param,''');']);
			elseif iscell( obj.transmission_param )	
				for p = 1:numel( obj.transmission_param )
					evalin(ws,['run(''',obj.transmission_param{p},''');']);
				end
			else
				assignin(ws,'transmission', obj.transmission_param);
			end
			
			
			% vehicle
			if ischar( obj.vehicle_param )			
				evalin(ws,['run(''',obj.vehicle_param,''');']);
			elseif iscell( obj.vehicle_param )	
				for p = 1:numel( obj.vehicle_param )
					evalin(ws,['run(''',obj.vehicle_param{p},''');']);
				end
			else
				assignin(ws,'vehicle', obj.vehicle_param);
			end
			
			
				% electric
			if ischar( obj.electric_param )			
				evalin(ws,['run(''',obj.electric_param,''');']);
			elseif iscell( obj.electric_param )	
				for p = 1:numel( obj.electric_param )
					evalin(ws,['run(''',obj.electric_param{p},''');']);
				end
			else
				assignin(ws,'electric', obj.electric_param);
			end
			
			% accessory
			if ischar( obj.accessory_param )			
				evalin(ws,['run(''',obj.accessory_param,''');']);
			elseif iscell( obj.accessory_param )	
				for p = 1:numel( obj.accessory_param )
					evalin(ws,['run(''',obj.accessory_param{p},''');']);
				end
			else
				assignin(ws,'accessory', obj.accessory_param);
			end
			
			% controls
			if isempty(obj.controls_param)
				% Do Nothing?
			elseif ischar( obj.controls_param )			
				evalin(ws,['run(''',obj.controls_param,''');']);
			elseif iscell( obj.controls_param )	
				for p = 1:numel( obj.controls_param )
					evalin(ws,['run(''',obj.controls_param{p},''');']);
				end
			else
				assignin(ws,'controls', obj.controls_param);
			end
					
						% driver
			if isempty(obj.driver_param)
				assignin(ws,'driver', class_REVS_driver);
			elseif ischar( obj.driver_param )			
				evalin(ws,['run(''',obj.driver_param,''');']);
			elseif iscell( obj.driver_param )	
				for p = 1:numel( obj.driver_param )
					evalin(ws,['run(''',obj.driver_param{p},''');']);
				end
			else
				assignin(ws,'driver', obj.driver_param);
			end
			
			
			
			% ambient
			if isempty(obj.ambient_param)
				assignin(ws,'ambient', class_REVS_ambient);
			elseif ischar( obj.ambient_param )			
				evalin(ws,['run(''',obj.ambient_param,''');']);
			elseif iscell( obj.ambient_param )	
				for p = 1:numel( obj.ambient_param )
					evalin(ws,['run(''',obj.ambient_param{p},''');']);
				end
			else
				assignin(ws,'ambient', obj.ambient_param);
			end
			
			
			
		end
		

	
		
		
		
	
	
	end
	
end

