function fields = findfields( s, search, varargin )
%FINDFIELDS find list of structure fields matching search string

% Parse varargs
is_wildcard = parse_varargs(varargin, 'regexp', true, 'toggle');

% If input isn't a struct bail
if ~isstruct(s)
    fields = '';
    return 
end


if is_wildcard  
    % Convert to regexp
    search = strrep( search, '.','\.');
    search = strrep( search, '*','.*');
    search = ['^', search,'$'];
end
    
fields = expand_struct(s,inputname(1) )';

match = regexp(fields,search,'once');
match = ~cellfun('isempty',match);
fields = fields(match);

end


function [ out ] = expand_struct( s , root_str)
%REVS_cleanup_exe_structures Remove strings and other invalid data types
%from structures for executable generation

    out = {};
    fns = fieldnames(s);
    
    for f = 1:length(fns)
    
        fn = fns{f};

        if isstruct( s.(fn) )
            % Recurse on structs    
            new_fields = expand_struct( s.(fn), [root_str,'.',fn]);   
            out = { out{:}, new_fields{:}};
        else   
            out{end+1} = sprintf( '%s.%s', root_str,fn);
        end

    end


end






