function [result] = run_shift_stats_func(verbose, datalog, result)

gear_changes = derivative(max(1,datalog.transmission.selected_gear_num),1);
gear_changes = gear_changes .* (abs(gear_changes) < 5);   % filter out bogus 0-6 shifts in raw Malibu data...

result.num_upshifts = sum(gear_changes > 0);
result.num_downshifts = sum(gear_changes < 0);
result.num_shifts = result.num_upshifts + result.num_downshifts;

if (verbose)
    fprintf(1,'\nShift Statistics:\n');
    fprintf(1,'   UpShift Count                 = %d\n', result.num_upshifts);
    fprintf(1,'   DownsShift Count              = %d\n', result.num_downshifts);
    fprintf(1,'   Total Shift Count             = %d\n', result.num_shifts);
%    fprintf(1,'   Shifts per mile               = %.1f\n', result.num_shifts/(audit.mech.vehicle.output_m(end) * convert.mtr2mi));
    fprintf(1,'   Shifts per mile               = %.1f\n', result.num_shifts/(datalog.vehicle.distance_m(end) * convert.mtr2mi));    
    fprintf(1,'\n');
end

%% cleanup
 clear gear_changes;
% clear num_upshifts;
% clear num_downshifts;
% clear num_shifts;

%%
% fplothg(time, datalog.gear_command)
% 
% shift_type = zeros(length(time),1);
% for i = 2:length(time)
%     if gear_changes(i) ~= 0
%         shift_type(i) = gear_changes(i);
%     else
%         shift_type(i) = shift_type(i-1);
%     end
% end
% 
% [interval_dt, mid_times, midindices, start_times, end_times, integral, shift_durations, shift_hist_data] = intervalyzer2((gear_changes == 0) & (audit.mech.vehicle.output_mps > 0), time, 'MinInterval', 0.1, 'MaxInterval', 10, 'DoPlots', false);
% [interval_dt, mid_times, midindices, start_times, end_times, integral, upshift_durations, upshift_hist_data] = intervalyzer2((gear_changes == 0) & (shift_type == 1) & (audit.mech.vehicle.output_mps > 0), time, 'MinInterval', 0.1, 'MaxInterval', 10, 'DoPlots', false);
% [interval_dt, mid_times, midindices, start_times, end_times, integral, downshift_durations, downshift_hist_data] = intervalyzer2((gear_changes == 0) & (shift_type == -1) & (audit.mech.vehicle.output_mps > 0), time, 'MinInterval', 0.1, 'MaxInterval', 10, 'DoPlots', false);
% 
% %fplothg(shift_durations, shift_hist_data, 'LineWidth', 2.5);
% fplothg(upshift_durations, upshift_hist_data,'b', 'LineWidth', 2.5);
% plothg(downshift_durations, downshift_hist_data,'r', 'LineWidth', 2.5);
% 
% % histogram of time in gear (while moving)
% [a, ps, ns, time_in_gear_bins, time_in_gear_hist, neghist] = newhist2x(datalog.gear_command .* (audit.mech.vehicle.output_mps > 0), transmission.gear.number, ones(length(time),1), time, 'NormalizeSum', 'Units', 'Seconds', 'DoPlots',false);
% figure; bar(time_in_gear_bins+0.5, time_in_gear_hist); grid on;
% xyt('Gear (#)','Time (S)', 'Time in gear while moving');
