function write_REVS_engine( file, engine )
%write_REVS_engine Summary of this function goes here
%   Detailed explanation goes here


fid = fopen( file ,'w');


%% Write to m-file
fprintf( fid,'%% ALPHA ENGINE DEFINITION\n'); 
fprintf( fid,'%% Generated %s\n',datestr(now)); 
fprintf( fid,'%% %s\n', engine.name); 


fprintf( fid,'\n%% Constructor\n'); 
fprintf( fid,'engine = class_REVS_engine();\n');
fprintf( fid, var2str('engine.name'));


fprintf( fid,'\n%% Physical Description\n');
fprintf(fid, var2str('engine.displacement_L'));
fprintf(fid, var2str('engine.num_cylinders'));
fprintf(fid, var2str('engine.combustion_type'));
fprintf(fid, var2str('engine.inertia_kgm2'));
print_if_field(fid, engine, 'bore_mm');
print_if_field(fid, engine, 'stroke_mm');


% fprintf( fid,var2str({'engine.num_cylinders','engine.bore_mm','engine.stroke_mm','engine.inertia_kgm2'}));


fprintf( fid, '\n%% Maximum Torque Curve\n');
fprintf( fid, var2str({'engine.full_throttle_speed_radps', 'engine.full_throttle_torque_Nm'}));


fprintf( fid, '\n%% Minimum Torque Curve\n');
fprintf( fid, var2str({'engine.closed_throttle_speed_radps', 'engine.closed_throttle_torque_Nm'}));

fprintf( fid, '\n%% Fuel Map\n');
fprintf( fid, var2str({'engine.fuel_map_speed_radps', 'engine.fuel_map_torque_Nm', 'engine.fuel_map_gps'}));

if isfield( engine, 'deac_fuel_map_gps')
	fprintf( fid, var2str({'engine.deac_fuel_map_gps'}));
end


fprintf( fid, '\n%% Fuel Properties\n');
if class_REVS_fuel.check_id(engine.fuel.id)
	fprintf(fid, 'engine.fuel = class_REVS_fuel(''%s'');\n', engine.fuel.id);
else
	% Not in table write individual fields
	fprintf( fid, var2str({'engine.fuel'}));
end

fprintf( fid, '\n%% Idle Speed\n');
fprintf( fid, var2str('engine.idle_speed_radps'));


fprintf( fid, '\n%% Pedal Calibration\n');
fprintf( fid, var2str({'engine.pedal_map_type'}));
if engine.pedal_map_type == enum_engine_pedal_map_type.lookup_table
	 fprintf( fid, var2str({'engine.pedal_map_speed_radps', 'engine.pedal_map_pedal_norm','engine.pedal_map_Nm'}));
end

if isfield( engine, 'fast_torque_fuel_adjust_norm')
	fprintf( fid, '\n%% Fuel response associated with rapid torque reduction \n');
	fprintf( fid, var2str({'engine.fast_torque_fuel_adjust_norm'}));
end



fclose(fid);
end



function print_if_field( fid, engine, field )
if isfield( engine, field)
	fprintf( fid, var2str({[inputname(2),'.',field]}));
end


end
