function [ revs_data ] = REVS_VM_engine_renamalyzer( revs_data, vehicle, engine, audit, datalog )

if ~isempty( vehicle.fuel )
	revs_data.vehicle.fuel.density_kgpL_15C     = vehicle.fuel.density_kgpL_15C;
	revs_data.vehicle.fuel.energy_density_MJpkg = vehicle.fuel.energy_density_MJpkg;
else
	revs_data.vehicle.fuel.density_kgpL_15C     = engine.fuel.density_kgpL_15C;
	revs_data.vehicle.fuel.energy_density_MJpkg = engine.fuel.energy_density_MJpkg;
end

revs_data.vehicle.fuel.flow_rate_gps        = datalog.engine.fuel_rate_gps;
revs_data.vehicle.fuel.mass_g               = datalog.engine.fuel_consumed_g;

revs_data.engine.speed_radps                = audit.mech.engine.crankshaft_radps;
revs_data.engine.gross_torque_Nm            = audit.mech.engine.crankshaft_gross_Nm;
revs_data.engine.crankshaft_torque_Nm       = audit.mech.engine.crankshaft_Nm;
revs_data.engine.load_at_current_speed_norm = datalog.engine.load_norm;
revs_data.engine.gross_power_kW             = audit.mech.engine.crankshaft_gross_kW;
revs_data.engine.crankshaft_power_kW        = audit.mech.engine.crankshaft_kW;
revs_data.engine.fuel.density_kgpL_15C      = engine.fuel.density_kgpL_15C;

revs_data.engine.fuel.energy_density_MJpkg  = engine.fuel.energy_density_MJpkg;
revs_data.engine.fuel.flow_rate_gps         = datalog.engine.fuel_rate_gps;
revs_data.engine.fuel.mass_g                = datalog.engine.fuel_consumed_g;

end
