/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class TinyMenuItemUI
extends MenuItemUI {
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_ICON_GAP = 4;
    private static final int DEFAULT_ACC_GAP = 8;
    private static final int DEFAULT_ARROW_GAP = 12;
    private static final int CHECK_WIDTH = 14;
    private static final int ARROW_WIDTH = 16;
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    public static final String MAX_TEXT_WIDTH = "TinyMenuItemUI.maxTextWidth";
    public static final String MAX_ICON_WIDTH = "TinyMenuItemUI.maxIconWidth";
    public static final String MAX_LABEL_WIDTH = "TinyMenuItemUI.maxLabelWidth";
    public static final String MAX_ACC_WIDTH = "TinyMenuItemUI.maxAccWidth";
    protected static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle acceleratorRect = new Rectangle();
    protected static Rectangle checkIconRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    protected static Rectangle rect = new Rectangle();

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (container != null && container instanceof JComponent) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
            jComponent2.putClientProperty(MAX_ICON_WIDTH, null);
            jComponent2.putClientProperty(MAX_LABEL_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string2, actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        return actionMapUIResource;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (Theme.menuAllowTwoIcons.getValue()) {
            return this.getPreferredMenuItemSizeTwoIcons(jComponent, this.checkIcon, this.arrowIcon);
        }
        return this.getPreferredMenuItemSizeOneIcon(jComponent, this.checkIcon, this.arrowIcon);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (this.isTopLevelMenu()) {
                graphics.setColor(Theme.menuDisabledFgColor.getColor());
            } else {
                graphics.setColor(Theme.menuItemDisabledFgColor.getColor());
            }
            TinyUtils.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            if (this.isTopLevelMenu()) {
                if (jMenuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover.getValue() && !buttonModel.isSelected()) {
                    graphics.setColor(Theme.menuRolloverFgColor.getColor());
                } else if (!(jMenuItem.getForeground() instanceof ColorUIResource)) {
                    graphics.setColor(jMenuItem.getForeground());
                } else {
                    graphics.setColor(Theme.menuFontColor.getColor());
                }
            } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(Theme.menuItemSelectedTextColor.getColor());
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            TinyUtils.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        rect.setBounds(zeroRect);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (Theme.menuAllowTwoIcons.getValue()) {
            this.paintMenuItemTwoIcons(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, 4);
        } else {
            this.paintMenuItemOneIcon(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, 4);
        }
    }

    private boolean isTopLevelMenu() {
        return this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu();
    }

    private boolean isTopLevelMenu(Component component) {
        return component instanceof JMenu && ((JMenu)component).isTopLevelMenu();
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyMenuItemUI();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont(string + ".acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        }
    }

    private String getAcceleratorText(KeyStroke keyStroke) {
        int n;
        if (keyStroke == null) {
            return "";
        }
        String string = "";
        int n2 = keyStroke.getModifiers();
        if (n2 > 0) {
            string = KeyEvent.getKeyModifiersText(n2);
            string = string + this.acceleratorDelimiter;
        }
        string = (n = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n) : string + keyStroke.getKeyChar();
        return string;
    }

    protected Dimension getPreferredMenuItemSizeTwoIcons(JComponent jComponent, Icon icon, Icon icon2) {
        int n;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        String string = jMenuItem.getText();
        String string2 = this.getAcceleratorText(jMenuItem.getAccelerator());
        boolean bl = this.isTopLevelMenu(jComponent);
        Icon icon3 = jMenuItem.getIcon();
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        int n2 = jMenuItem.getHorizontalAlignment();
        int n3 = jMenuItem.getHorizontalTextPosition();
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), n2, jMenuItem.getVerticalTextPosition(), n3, viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : 4, true);
        rect.setBounds(textRect);
        rect = SwingUtilities.computeUnion(TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y, TinyMenuItemUI.iconRect.width, TinyMenuItemUI.iconRect.height, rect);
        Insets insets = jMenuItem.getInsets();
        if (bl) {
            TinyMenuItemUI.rect.width += insets.left + insets.right;
            TinyMenuItemUI.rect.height += insets.top + insets.bottom;
            TinyMenuItemUI.rect.width += 5;
            return rect.getSize();
        }
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        Integer n4 = (Integer)jComponent2.getClientProperty(MAX_TEXT_WIDTH);
        int n5 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_LABEL_WIDTH);
        int n6 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_ICON_WIDTH);
        int n7 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
        int n8 = n = n4 == null ? 0 : n4;
        if (n3 == 2 || n3 == 10 || n3 == 0) {
            if (TinyMenuItemUI.rect.width > n5) {
                n5 = TinyMenuItemUI.rect.width;
                jComponent2.putClientProperty(MAX_TEXT_WIDTH, new Integer(n5));
            } else if (n5 > 0) {
                TinyMenuItemUI.rect.width = n5;
            }
        } else {
            if (TinyMenuItemUI.textRect.width > n5) {
                n5 = TinyMenuItemUI.textRect.width;
                jComponent2.putClientProperty(MAX_TEXT_WIDTH, new Integer(n5));
            } else if (n5 > 0 && TinyMenuItemUI.iconRect.width < n5) {
                TinyMenuItemUI.rect.width += n5 - TinyMenuItemUI.textRect.width;
            }
            if (n2 == 2 || n2 == 10) {
                if (TinyMenuItemUI.iconRect.width > n7) {
                    n7 = TinyMenuItemUI.iconRect.width;
                    jComponent2.putClientProperty(MAX_ICON_WIDTH, new Integer(n7));
                } else if (TinyMenuItemUI.iconRect.width > 0) {
                    TinyMenuItemUI.rect.width += n7 - TinyMenuItemUI.iconRect.width;
                }
            }
        }
        if (TinyMenuItemUI.rect.width > n6) {
            n6 = TinyMenuItemUI.rect.width;
            jComponent2.putClientProperty(MAX_LABEL_WIDTH, new Integer(n6));
        } else if (n6 > 0) {
            TinyMenuItemUI.rect.width = n6;
        }
        if (TinyMenuItemUI.acceleratorRect.width > n) {
            n = TinyMenuItemUI.acceleratorRect.width;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, new Integer(n));
        }
        TinyMenuItemUI.rect.width += Math.max(insets.left + insets.right, 11);
        TinyMenuItemUI.rect.height += insets.top + insets.bottom;
        TinyMenuItemUI.rect.width += 30;
        if (n > 0) {
            TinyMenuItemUI.rect.width += n + 8;
        }
        return rect.getSize();
    }

    protected Dimension getPreferredMenuItemSizeOneIcon(JComponent jComponent, Icon icon, Icon icon2) {
        int n;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        String string = jMenuItem.getText();
        String string2 = this.getAcceleratorText(jMenuItem.getAccelerator());
        boolean bl = this.isTopLevelMenu(jComponent);
        Icon icon3 = jMenuItem.getIcon();
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        int n2 = jMenuItem.getHorizontalAlignment();
        int n3 = jMenuItem.getHorizontalTextPosition();
        if (icon3 == null && icon != null) {
            icon3 = icon;
            icon = null;
        }
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), n2, jMenuItem.getVerticalTextPosition(), n3, viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : 4, true);
        rect.setBounds(textRect);
        rect = SwingUtilities.computeUnion(TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y, TinyMenuItemUI.iconRect.width, TinyMenuItemUI.iconRect.height, rect);
        Insets insets = jMenuItem.getInsets();
        if (bl) {
            TinyMenuItemUI.rect.width += insets.left + insets.right;
            TinyMenuItemUI.rect.height += insets.top + insets.bottom;
            TinyMenuItemUI.rect.width += 5;
            return rect.getSize();
        }
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        Integer n4 = (Integer)jComponent2.getClientProperty(MAX_TEXT_WIDTH);
        int n5 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_LABEL_WIDTH);
        int n6 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_ICON_WIDTH);
        int n7 = n4 == null ? 0 : n4;
        n4 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
        int n8 = n = n4 == null ? 0 : n4;
        if (n3 == 2 || n3 == 10 || n3 == 0) {
            if (TinyMenuItemUI.rect.width > n5) {
                n5 = TinyMenuItemUI.rect.width;
                jComponent2.putClientProperty(MAX_TEXT_WIDTH, new Integer(n5));
            } else if (n5 > 0) {
                TinyMenuItemUI.rect.width = n5;
            }
        } else {
            if (TinyMenuItemUI.textRect.width > n5) {
                n5 = TinyMenuItemUI.textRect.width;
                jComponent2.putClientProperty(MAX_TEXT_WIDTH, new Integer(n5));
            } else if (n5 > 0 && TinyMenuItemUI.iconRect.width < n5) {
                TinyMenuItemUI.rect.width += n5 - TinyMenuItemUI.textRect.width;
            }
            if (n2 == 2 || n2 == 10) {
                if (TinyMenuItemUI.iconRect.width > n7) {
                    n7 = TinyMenuItemUI.iconRect.width;
                    jComponent2.putClientProperty(MAX_ICON_WIDTH, new Integer(n7));
                } else if (TinyMenuItemUI.iconRect.width > 0) {
                    TinyMenuItemUI.rect.width += n7 - TinyMenuItemUI.iconRect.width;
                }
            }
        }
        if (TinyMenuItemUI.rect.width > n6) {
            n6 = TinyMenuItemUI.rect.width;
            jComponent2.putClientProperty(MAX_LABEL_WIDTH, new Integer(n6));
        } else if (n6 > 0) {
            TinyMenuItemUI.rect.width = n6;
        }
        if (TinyMenuItemUI.acceleratorRect.width > n) {
            n = TinyMenuItemUI.acceleratorRect.width;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, new Integer(n));
        }
        TinyMenuItemUI.rect.width += Math.max(insets.left + insets.right, 11);
        TinyMenuItemUI.rect.height += insets.top + insets.bottom;
        TinyMenuItemUI.rect.width += 16;
        if (n > 0) {
            TinyMenuItemUI.rect.width += n + 8;
        }
        return rect.getSize();
    }

    private String p(Rectangle rectangle) {
        if (rectangle == null) {
            return "null";
        }
        return rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
    }

    private String p(Insets insets) {
        if (insets == null) {
            return "null";
        }
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
    }

    private String p(Dimension dimension) {
        if (dimension == null) {
            return "null";
        }
        return dimension.width + ", " + dimension.height;
    }

    private String getSwingConstantsString(int n) {
        if (n == 0) {
            return "CENTER";
        }
        if (n == 10) {
            return "LEADING";
        }
        if (n == 2) {
            return "LEFT";
        }
        if (n == 4) {
            return "RIGHT";
        }
        if (n == 11) {
            return "TRAILING";
        }
        return "???";
    }

    private String getSwingConstantsString(int n, int n2) {
        return this.getSwingConstantsString(n) + ", " + this.getSwingConstantsString(n2);
    }

    protected void paintMenuItemTwoIcons(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        JComponent jComponent2 = (JComponent)jMenuItem.getParent();
        Integer n2 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
        int n3 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_ICON_WIDTH);
        int n4 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_LABEL_WIDTH);
        int n5 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_TEXT_WIDTH);
        int n6 = n2 == null ? 0 : n2;
        int n7 = jMenuItem.getWidth();
        int n8 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        boolean bl = this.isTopLevelMenu();
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        int n9 = jMenuItem.getHorizontalAlignment();
        int n10 = jMenuItem.getHorizontalTextPosition();
        this.resetRects();
        viewRect.setBounds(0, 0, n7, n8);
        TinyMenuItemUI.viewRect.x += insets.left;
        TinyMenuItemUI.viewRect.y += insets.top;
        TinyMenuItemUI.viewRect.width -= insets.right + insets.left;
        TinyMenuItemUI.viewRect.height -= insets.bottom + insets.top;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        String string = this.getAcceleratorText(jMenuItem.getAccelerator());
        Icon icon3 = jMenuItem.getIcon();
        Icon icon4 = null;
        Icon icon5 = icon3;
        if (jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JRadioButtonMenuItem) {
            icon4 = icon;
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, icon3, icon4, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, false);
        if (!bl) {
            int n11;
            int n12;
            if (bl2) {
                TinyMenuItemUI.checkIconRect.x = insets.left;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 14 + n5 + 8;
                if (n10 == 4 || n10 == 11) {
                    TinyMenuItemUI.iconRect.x = insets.left + 14;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + n4 + (n4 == 0 ? 0 : 4);
                    if (n9 == 4 || n9 == 11) {
                        n12 = insets.left + 14 + n5;
                        n11 = n12 - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.textRect.x = n12 - TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    } else if (n9 == 0) {
                        n12 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = insets.left + 14 + (n5 - n12) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4);
                    }
                } else if (n10 == 2 || n10 == 10) {
                    TinyMenuItemUI.textRect.x = insets.left + 14 + n4 + (n4 == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    if (n9 == 4 || n9 == 11) {
                        n12 = insets.left + 14 + n5;
                        n11 = n12 - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.iconRect.x = n12 - TinyMenuItemUI.iconRect.width;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x - 4 - TinyMenuItemUI.textRect.width;
                    } else if (n9 == 0) {
                        n12 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = insets.left + 14 + (n5 - n12) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (n10 == 0) {
                    n12 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    n11 = insets.left + 14 + n4 + (n4 == 0 ? 0 : 4);
                    int n13 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n11 - TinyMenuItemUI.textRect.x : n11 - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += n13;
                    TinyMenuItemUI.textRect.x += n13;
                    if (n9 == 4 || n9 == 11) {
                        int n14 = insets.left + 14 + n5;
                        n11 = n14 - n12;
                        n13 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n11 - TinyMenuItemUI.textRect.x : n11 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n13;
                        TinyMenuItemUI.textRect.x += n13;
                    } else if (n9 == 0) {
                        n11 = insets.left + 14 + (n5 - n12) / 2;
                        n13 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n11 - TinyMenuItemUI.textRect.x : n11 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n13;
                        TinyMenuItemUI.textRect.x += n13;
                    }
                }
            } else {
                TinyMenuItemUI.checkIconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - 14 + 4;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 16 + n3 - TinyMenuItemUI.acceleratorRect.width;
                if (n10 == 4 || n10 == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - n4 - (n4 == 0 ? 0 : 4) - TinyMenuItemUI.textRect.width;
                    if (n9 == 4 || n9 == 11) {
                        TinyMenuItemUI.textRect.x = n12 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        TinyMenuItemUI.iconRect.x = n12 + TinyMenuItemUI.textRect.width + 4;
                    } else if (n9 == 0) {
                        n12 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        n11 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = n12 + (n5 - n11) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (n10 == 2 || n10 == 10) {
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.textRect.width - n4 - (n4 == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    if (n9 == 4 || n9 == 11) {
                        TinyMenuItemUI.iconRect.x = n12 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        TinyMenuItemUI.textRect.x = n12 + TinyMenuItemUI.iconRect.width + 4;
                    } else if (n9 == 0) {
                        n12 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        n11 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = n12 + (n5 - n11) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + 4;
                    }
                } else if (n10 == 0) {
                    n12 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                    n11 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    int n15 = n12 + n6 - n11;
                    int n16 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n15 - TinyMenuItemUI.textRect.x : n15 - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += n16;
                    TinyMenuItemUI.textRect.x += n16;
                    if (n9 == 4 || n9 == 11) {
                        n16 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n12 - TinyMenuItemUI.textRect.x : n12 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n16;
                        TinyMenuItemUI.textRect.x += n16;
                    } else if (n9 == 0) {
                        n15 = n12 + (n5 - n11) / 2;
                        n16 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n15 - TinyMenuItemUI.textRect.x : n15 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n16;
                        TinyMenuItemUI.textRect.x += n16;
                    }
                }
            }
        }
        this.paintBackground(graphics, jMenuItem, color, bl2);
        Color color3 = graphics.getColor();
        if (icon4 != null && !bl) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            icon4.paintIcon(jComponent, graphics, TinyMenuItemUI.checkIconRect.x, TinyMenuItemUI.checkIconRect.y);
            graphics.setColor(color3);
        }
        if (icon5 != null) {
            Icon icon6;
            if (!buttonModel.isEnabled()) {
                icon6 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon6 = jMenuItem.getPressedIcon();
                if (icon6 == null) {
                    icon6 = jMenuItem.getIcon();
                }
            } else if (buttonModel.isSelected()) {
                icon6 = jMenuItem.getSelectedIcon();
                if (icon6 == null) {
                    icon6 = jMenuItem.getIcon();
                }
            } else {
                icon6 = buttonModel.isArmed() ? jMenuItem.getIcon() : jMenuItem.getIcon();
            }
            if (icon6 != null) {
                icon6.paintIcon(jComponent, graphics, TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y);
            }
        }
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            graphics.setColor(Theme.menuItemFontColor.getColor());
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (!"".equals(string)) {
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(Theme.menuItemDisabledFgColor.getColor());
                BasicGraphicsUtils.drawString(graphics, string, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(Theme.menuItemSelectedTextColor.getColor());
                } else {
                    graphics.setColor(Theme.menuItemFontColor.getColor());
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!bl) {
                icon2.paintIcon(jComponent, graphics, TinyMenuItemUI.arrowIconRect.x, TinyMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintMenuItemOneIcon(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        JComponent jComponent2 = (JComponent)jMenuItem.getParent();
        Integer n2 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
        int n3 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_ICON_WIDTH);
        int n4 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_LABEL_WIDTH);
        int n5 = n2 == null ? 0 : n2;
        n2 = (Integer)jComponent2.getClientProperty(MAX_TEXT_WIDTH);
        int n6 = n2 == null ? 0 : n2;
        int n7 = jMenuItem.getWidth();
        int n8 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        boolean bl = this.isTopLevelMenu();
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        int n9 = jMenuItem.getHorizontalAlignment();
        int n10 = jMenuItem.getHorizontalTextPosition();
        this.resetRects();
        viewRect.setBounds(0, 0, n7, n8);
        TinyMenuItemUI.viewRect.x += insets.left;
        TinyMenuItemUI.viewRect.y += insets.top;
        TinyMenuItemUI.viewRect.width -= insets.right + insets.left;
        TinyMenuItemUI.viewRect.height -= insets.bottom + insets.top;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        String string = this.getAcceleratorText(jMenuItem.getAccelerator());
        Icon icon3 = jMenuItem.getIcon();
        Icon icon4 = null;
        Icon icon5 = icon3;
        if ((jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JRadioButtonMenuItem) && icon3 == null) {
            icon4 = icon;
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, icon3, icon4, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, false);
        if (!bl) {
            int n11;
            int n12;
            int n13;
            int n14;
            if (bl2) {
                TinyMenuItemUI.checkIconRect.x = insets.left;
                TinyMenuItemUI.acceleratorRect.x = insets.left + n5 + 8;
                if (n10 == 4 || n10 == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.checkIconRect.x;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + n4 + (n4 == 0 ? 0 : 4);
                    if (n9 == 4 || n9 == 11) {
                        n14 = insets.left + n5;
                        n13 = n14 - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.textRect.x = n14 - TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    } else if (n9 == 0) {
                        n14 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = insets.left + (n5 - n14) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4);
                    }
                } else if (n10 == 2 || n10 == 10) {
                    TinyMenuItemUI.textRect.x = insets.left + n4 + (n4 == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    if (n9 == 4 || n9 == 11) {
                        n14 = insets.left + n5;
                        n13 = n14 - (TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width);
                        TinyMenuItemUI.iconRect.x = n14 - TinyMenuItemUI.iconRect.width;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x - 4 - TinyMenuItemUI.textRect.width;
                    } else if (n9 == 0) {
                        n14 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = insets.left + (n5 - n14) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (n10 == 0) {
                    n14 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    n13 = insets.left + n4 + (n4 == 0 ? 0 : 4);
                    n12 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n13 - TinyMenuItemUI.textRect.x : n13 - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += n12;
                    TinyMenuItemUI.textRect.x += n12;
                    if (n9 == 4 || n9 == 11) {
                        n11 = insets.left + n5;
                        n13 = n11 - n14;
                        n12 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n13 - TinyMenuItemUI.textRect.x : n13 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n12;
                        TinyMenuItemUI.textRect.x += n12;
                    } else if (n9 == 0) {
                        n13 = insets.left + (n5 - n14) / 2;
                        n12 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n13 - TinyMenuItemUI.textRect.x : n13 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n12;
                        TinyMenuItemUI.textRect.x += n12;
                    }
                }
            } else {
                TinyMenuItemUI.checkIconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - 14 + 4;
                TinyMenuItemUI.acceleratorRect.x = insets.left + 16 + n3 - TinyMenuItemUI.acceleratorRect.width;
                if (n10 == 4 || n10 == 11) {
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.viewRect.x + TinyMenuItemUI.viewRect.width - TinyMenuItemUI.iconRect.width;
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - n4 - (n4 == 0 ? 0 : 4) - TinyMenuItemUI.textRect.width;
                    if (n9 == 4 || n9 == 11) {
                        TinyMenuItemUI.textRect.x = n14 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        TinyMenuItemUI.iconRect.x = n14 + TinyMenuItemUI.textRect.width + 4;
                    } else if (n9 == 0) {
                        n14 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        n13 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.textRect.x = n14 + (n5 - n13) / 2;
                        TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x + TinyMenuItemUI.textRect.width + 4;
                    }
                } else if (n10 == 2 || n10 == 10) {
                    TinyMenuItemUI.textRect.x = TinyMenuItemUI.checkIconRect.x - 4 - TinyMenuItemUI.textRect.width - n4 - (n4 == 0 ? 0 : 4);
                    TinyMenuItemUI.iconRect.x = TinyMenuItemUI.textRect.x - 4 - TinyMenuItemUI.iconRect.width;
                    if (n9 == 4 || n9 == 11) {
                        TinyMenuItemUI.iconRect.x = n14 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        TinyMenuItemUI.textRect.x = n14 + TinyMenuItemUI.iconRect.width + 4;
                    } else if (n9 == 0) {
                        n14 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                        n13 = TinyMenuItemUI.iconRect.width + (TinyMenuItemUI.iconRect.width == 0 ? 0 : 4) + TinyMenuItemUI.textRect.width;
                        TinyMenuItemUI.iconRect.x = n14 + (n5 - n13) / 2;
                        TinyMenuItemUI.textRect.x = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width + 4;
                    }
                } else if (n10 == 0) {
                    n14 = insets.left + 16 + n3 + (n3 == 0 ? 0 : 8);
                    n13 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? TinyMenuItemUI.textRect.width : TinyMenuItemUI.iconRect.width;
                    n12 = n14 + n6 - n13;
                    n11 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n12 - TinyMenuItemUI.textRect.x : n12 - TinyMenuItemUI.iconRect.x;
                    TinyMenuItemUI.iconRect.x += n11;
                    TinyMenuItemUI.textRect.x += n11;
                    if (n9 == 4 || n9 == 11) {
                        n11 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n14 - TinyMenuItemUI.textRect.x : n14 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n11;
                        TinyMenuItemUI.textRect.x += n11;
                    } else if (n9 == 0) {
                        n12 = n14 + (n5 - n13) / 2;
                        n11 = TinyMenuItemUI.textRect.width > TinyMenuItemUI.iconRect.width ? n12 - TinyMenuItemUI.textRect.x : n12 - TinyMenuItemUI.iconRect.x;
                        TinyMenuItemUI.iconRect.x += n11;
                        TinyMenuItemUI.textRect.x += n11;
                    }
                }
            }
        }
        this.paintBackground(graphics, jMenuItem, color, bl2);
        Color color3 = graphics.getColor();
        if (icon4 != null && !bl) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            icon4.paintIcon(jComponent, graphics, TinyMenuItemUI.checkIconRect.x, TinyMenuItemUI.checkIconRect.y);
            graphics.setColor(color3);
        }
        if (icon5 != null) {
            Icon icon6 = icon5;
            Icon icon7 = null;
            Icon icon8 = null;
            if (buttonModel.isSelected() && (icon7 = jMenuItem.getSelectedIcon()) != null) {
                icon6 = icon7;
            }
            if (!buttonModel.isEnabled()) {
                if (buttonModel.isSelected() && (icon8 = jMenuItem.getDisabledSelectedIcon()) == null) {
                    icon8 = icon7;
                }
                if (icon8 == null) {
                    icon8 = jMenuItem.getDisabledIcon();
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon8 = jMenuItem.getPressedIcon();
            } else if (buttonModel.isArmed()) {
                if (buttonModel.isSelected() && (icon8 = jMenuItem.getRolloverSelectedIcon()) == null) {
                    icon8 = icon7;
                }
                if (icon8 == null) {
                    icon8 = jMenuItem.getRolloverIcon();
                }
            }
            if (icon8 != null) {
                icon6 = icon8;
            }
            if (icon6 != null) {
                icon6.paintIcon(jComponent, graphics, TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y);
                if ((jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JRadioButtonMenuItem) && jMenuItem.getSelectedIcon() == null && buttonModel.isSelected()) {
                    this.paintSelected(graphics, jMenuItem);
                }
            }
        }
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            graphics.setColor(Theme.menuItemFontColor.getColor());
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (!"".equals(string)) {
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(Theme.menuItemDisabledFgColor.getColor());
                BasicGraphicsUtils.drawString(graphics, string, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(Theme.menuItemSelectedTextColor.getColor());
                } else {
                    graphics.setColor(Theme.menuItemFontColor.getColor());
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, TinyMenuItemUI.acceleratorRect.x, TinyMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!bl) {
                icon2.paintIcon(jComponent, graphics, TinyMenuItemUI.arrowIconRect.x, TinyMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private void paintSelected(Graphics graphics, JMenuItem jMenuItem) {
        ColorUIResource colorUIResource;
        ColorUIResource colorUIResource2;
        if (!jMenuItem.isEnabled()) {
            colorUIResource2 = Theme.menuIconDisabledColor.getColor();
            colorUIResource = Theme.menuPopupColor.getColor();
        } else if (jMenuItem.isArmed()) {
            colorUIResource2 = Theme.menuIconRolloverColor.getColor();
            colorUIResource = Theme.menuItemRolloverColor.getColor();
        } else {
            colorUIResource2 = Theme.menuIconColor.getColor();
            colorUIResource = Theme.menuPopupColor.getColor();
        }
        int n = TinyMenuItemUI.iconRect.x - 3;
        int n2 = TinyMenuItemUI.iconRect.y - 1;
        if (jMenuItem.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            n = TinyMenuItemUI.iconRect.x + TinyMenuItemUI.iconRect.width - 4;
        }
        graphics.translate(n, n2);
        graphics.setColor(colorUIResource2);
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            graphics.drawLine(0, 2, 0, 4);
            graphics.drawLine(1, 3, 1, 5);
            graphics.drawLine(2, 4, 2, 6);
            graphics.drawLine(3, 3, 3, 5);
            graphics.drawLine(4, 2, 4, 4);
            graphics.drawLine(5, 1, 5, 3);
            graphics.drawLine(6, 0, 6, 2);
            graphics.setColor(colorUIResource);
            graphics.drawLine(3, 1, 4, 1);
            graphics.drawLine(3, 2, 3, 2);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 128));
            graphics.drawLine(3, 6, 3, 6);
            graphics.drawLine(4, 5, 4, 5);
            graphics.drawLine(5, 4, 5, 4);
            graphics.drawLine(6, 3, 6, 3);
        } else {
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 96));
            graphics.drawLine(1, 0, 1, 0);
            graphics.drawLine(5, 0, 5, 0);
            graphics.drawLine(0, 1, 0, 1);
            graphics.drawLine(6, 1, 6, 1);
            graphics.drawLine(0, 5, 0, 5);
            graphics.drawLine(6, 5, 6, 5);
            graphics.drawLine(1, 6, 1, 6);
            graphics.drawLine(5, 6, 5, 6);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 184));
            graphics.drawLine(2, 0, 2, 0);
            graphics.drawLine(4, 0, 4, 0);
            graphics.drawLine(0, 2, 0, 2);
            graphics.drawLine(6, 2, 6, 2);
            graphics.drawLine(0, 4, 0, 4);
            graphics.drawLine(6, 4, 6, 4);
            graphics.drawLine(2, 6, 2, 6);
            graphics.drawLine(4, 6, 4, 6);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 245));
            graphics.drawLine(3, 0, 3, 0);
            graphics.drawLine(3, 6, 3, 6);
            graphics.drawLine(0, 3, 0, 3);
            graphics.drawLine(6, 3, 6, 3);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 159));
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(5, 1, 5, 1);
            graphics.drawLine(1, 5, 1, 5);
            graphics.drawLine(5, 5, 5, 5);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 71));
            graphics.drawLine(2, 1, 2, 1);
            graphics.drawLine(4, 1, 4, 1);
            graphics.drawLine(1, 2, 1, 2);
            graphics.drawLine(5, 2, 5, 2);
            graphics.drawLine(1, 4, 1, 4);
            graphics.drawLine(5, 4, 5, 4);
            graphics.drawLine(2, 5, 2, 5);
            graphics.drawLine(4, 5, 4, 5);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 112));
            graphics.drawLine(2, 2, 2, 2);
            graphics.drawLine(4, 2, 4, 2);
            graphics.drawLine(2, 4, 2, 4);
            graphics.drawLine(4, 4, 4, 4);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 224));
            graphics.drawLine(3, 2, 3, 2);
            graphics.drawLine(3, 4, 3, 4);
            graphics.drawLine(2, 3, 2, 3);
            graphics.drawLine(4, 3, 4, 3);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(3, 3, 3, 3);
            graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 128));
            graphics.drawLine(3, 1, 3, 1);
            graphics.drawLine(5, 3, 5, 3);
            graphics.drawLine(3, 5, 3, 5);
        }
        graphics.translate(-n, -n2);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color, boolean bl) {
        boolean bl2;
        if (!jMenuItem.isOpaque()) {
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        boolean bl3 = bl2 = buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected();
        if (this.isTopLevelMenu(jMenuItem)) {
            Color color3 = jMenuItem.getParent().getBackground();
            if (color3 instanceof ColorUIResource) {
                color3 = Theme.menuBarColor.getColor();
            }
            if (buttonModel.isSelected()) {
                graphics.setColor(color3);
                graphics.fillRect(0, 0, n, n2);
                this.paintXpTopMenuBorder(graphics, 0, 0, n, n2, true, bl, color3);
            } else if (jMenuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover.getValue()) {
                graphics.setColor(Theme.menuRolloverBgColor.getColor());
                if (bl) {
                    graphics.fillRect(0, 0, n - 5, n2);
                    graphics.setColor(color3);
                    graphics.fillRect(n - 5, 0, 5, n2);
                } else {
                    graphics.fillRect(5, 0, n, n2);
                    graphics.setColor(color3);
                    graphics.fillRect(0, 0, 5, n2);
                }
                this.paintXpTopMenuBorder(graphics, 0, 0, n, n2, false, bl, color3);
            } else {
                if (jMenuItem.getBackground() instanceof ColorUIResource) {
                    graphics.setColor(color3);
                } else {
                    graphics.setColor(jMenuItem.getBackground());
                }
                graphics.fillRect(0, 0, n, n2);
            }
        } else if (bl2) {
            graphics.setColor(Theme.menuItemRolloverColor.getColor());
            graphics.fillRect(0, 0, n, n2);
        } else {
            if (jMenuItem.getBackground() instanceof ColorUIResource) {
                graphics.setColor(Theme.menuPopupColor.getColor());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color2);
    }

    private void paintXpTopMenuBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color) {
        graphics.setColor(Theme.menuBorderColor.getColor());
        if (bl) {
            if (bl2) {
                graphics.drawLine(n, n2, n + n3 - 5 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 5 - 1, n2, n + n3 - 5 - 1, n2 + n4 - 1);
                this.paintTopMenuShadow(graphics, n + n3 - 5, n2 + 1, 5, n4 - 1, bl2);
            } else {
                graphics.drawLine(n + 5, n2, n + n3 - 1, n2);
                graphics.drawLine(n + 5, n2, n + 5, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                this.paintTopMenuShadow(graphics, n, n2 + 1, 5, n4 - 1, bl2);
            }
        } else if (bl2) {
            graphics.drawRect(n, n2, n3 - 5 - 1, n4 - 1);
        } else {
            graphics.drawRect(n + 5, n2, n3 - 5 - 1, n4 - 1);
        }
    }

    private void paintTopMenuShadow(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            Image image = TinyPopupMenuBorder.LEFT_TO_RIGHT_SHADOW_MASK;
            graphics.drawImage(image, n, n2, n + 5, n2 + 4, 6, 0, 11, 4, null);
            graphics.drawImage(image, n, n2 + 4, n + 5, n2 + n4, 6, 4, 11, 5, null);
        } else {
            Image image = TinyPopupMenuBorder.RIGHT_TO_LEFT_SHADOW_MASK;
            graphics.drawImage(image, n, n2, n + 5, n2 + 4, 0, 0, 5, 4, null);
            graphics.drawImage(image, n, n2 + 4, n + 5, n2 + n4, 0, 4, 5, 5, null);
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, boolean bl) {
        boolean bl2 = this.isTopLevelMenu();
        boolean bl3 = icon != null && icon.getIconWidth() > 0;
        boolean bl4 = this.menuItem.getComponentOrientation().isLeftToRight();
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, bl3 ? n5 : 0);
        if (!bl2) {
            if (bl4) {
                rectangle2.x += 14;
                rectangle3.x += 14;
            } else {
                rectangle2.x -= 14;
                rectangle3.x -= 14;
            }
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (!bl2) {
            if (icon2 != null) {
                rectangle5.height = icon2.getIconHeight();
                rectangle5.width = icon2.getIconWidth();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        } else {
            rectangle5.height = 0;
            rectangle5.width = 0;
            rectangle6.height = 0;
            rectangle6.width = 0;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (!bl2) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
            rectangle6.x = bl4 ? rectangle.x + rectangle.width - rectangle6.width : rectangle.x;
        }
        return string;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                TinyMenuItemUI.this.updateAcceleratorBinding();
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < TinyMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < TinyMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(TinyMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

