/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyFrameBorder
extends AbstractBorder
implements UIResource {
    public static final int FRAME_BORDER_WIDTH = 3;
    public static final int FRAME_TITLE_HEIGHT = 29;
    public static final int FRAME_INTERNAL_TITLE_HEIGHT = 25;
    public static final int FRAME_PALETTE_TITLE_HEIGHT = 21;
    public static Color buttonUpperDisabledColor;
    public static Color buttonLowerDisabledColor;
    private static final Rectangle theRect;
    private static TinyFrameBorder onlyInstance;
    private Window window;
    private int titleHeight;
    private boolean isActive;

    public static TinyFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new TinyFrameBorder();
        }
        return onlyInstance;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.window = SwingUtilities.getWindowAncestor(component);
        this.isActive = this.window.isActive();
        this.titleHeight = this.window instanceof JFrame ? 29 : (this.window instanceof JDialog ? 29 : 25);
        if (this.isActive) {
            graphics.setColor(Theme.frameBorderColor.getColor());
        } else {
            graphics.setColor(Theme.frameBorderDisabledColor.getColor());
        }
        this.drawXpBorder(graphics, n, n2, n3, n4);
    }

    private void drawXpBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        graphics.drawLine(n, n2 + 6, n, n2 + n4 - 1);
        graphics.drawLine(n + 2, n2 + this.titleHeight, n + 2, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 1, n2 + 6, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 3, n2 + this.titleHeight, n + n3 - 3, n2 + n4 - 3);
        graphics.drawLine(n + 2, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        if (TinyLookAndFeel.ROBOT != null) {
            int n6 = this.window.getLocationOnScreen().x - 4;
            n5 = this.window.getLocationOnScreen().y;
            theRect.setBounds(n6, n5, 4, 4);
            graphics.drawImage(TinyLookAndFeel.ROBOT.createScreenCapture(theRect), n, n2, null);
            n6 = this.window.getLocationOnScreen().x + this.window.getWidth() + 1;
            theRect.setBounds(n6, n5, 4, 4);
            graphics.drawImage(TinyLookAndFeel.ROBOT.createScreenCapture(theRect), n + n3 - 4, n2, null);
        } else {
            graphics.setColor(Theme.backColor.getColor());
            graphics.fillRect(0, 0, n3, 3);
        }
        if (this.isActive) {
            graphics.setColor(Theme.frameCaptionColor.getColor());
        } else {
            graphics.setColor(Theme.frameCaptionDisabledColor.getColor());
        }
        graphics.drawLine(n + 1, n2 + this.titleHeight, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + this.titleHeight, n + n3 - 2, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        ColorUIResource colorUIResource = null;
        colorUIResource = this.isActive ? Theme.frameBorderColor.getColor() : Theme.frameBorderDisabledColor.getColor();
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n, n2 + 3, n, n2 + 3);
        graphics.drawLine(n + n3 - 1, n2 + 3, n + n3 - 1, n2 + 3);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n, n2 + 4, n, n2 + 4);
        graphics.drawLine(n + n3 - 1, n2 + 4, n + n3 - 1, n2 + 4);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n, n2 + 5, n, n2 + 5);
        graphics.drawLine(n + n3 - 1, n2 + 5, n + n3 - 1, n2 + 5);
        colorUIResource = this.isActive ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        n5 = Theme.frameSpreadDarkDisabled.getValue();
        int n7 = Theme.frameSpreadLightDisabled.getValue();
        ColorUIResource colorUIResource2 = null;
        if (this.isActive) {
            colorUIResource2 = Theme.frameBorderColor.getColor();
            n5 = Theme.frameSpreadDark.getValue();
            n7 = Theme.frameSpreadLight.getValue();
        }
        int n8 = 1;
        Color color = ColorRoutines.darken(colorUIResource, 4 * n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 139));
        graphics.drawLine(n + 2, n8, n + 2, n8);
        graphics.drawLine(n + n3 - 3, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 23));
        graphics.drawLine(n + 1, n8, n + 1, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 2, n8);
        color = ColorRoutines.darken(colorUIResource, 6 * n5);
        graphics.setColor(color);
        graphics.drawLine(n + 2, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 3, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 139));
        graphics.drawLine(n + 1, n8, n + 1, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 2, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n + 2, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 3, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 6 * n5));
        graphics.drawLine(n + 1, n8, n + 1, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 2, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 6 * n5));
        graphics.drawLine(n + 1, ++n8, n + 1, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 2, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n + 2, n8, n + 2, n8);
        graphics.drawLine(n + n3 - 3, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 4 * n5));
        graphics.drawLine(n + 2, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 3, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 4 * n5));
        graphics.drawLine(n + 1, n8, n + 1, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 2, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 4 * n5));
        graphics.fillRect(n + 1, ++n8, 2, 2);
        graphics.fillRect(n + n3 - 3, n8, 2, 2);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 3 * n5));
        graphics.fillRect(n + 1, n8 += 2, 2, 4);
        graphics.fillRect(n + n3 - 3, n8, 2, 4);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n5));
        graphics.fillRect(n + 1, n8 += 4, 2, 3);
        graphics.fillRect(n + n3 - 3, n8, 2, 3);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 1 * n5));
        graphics.fillRect(n + 1, n8 += 3, 2, 2);
        graphics.fillRect(n + n3 - 3, n8, 2, 2);
        graphics.setColor(colorUIResource);
        graphics.fillRect(n + 1, n8 += 2, 2, 2);
        graphics.fillRect(n + n3 - 3, n8, 2, 2);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 2 * n7));
        graphics.drawLine(n + 1, n8 += 2, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 5 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 6 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 8 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 9 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n5));
        graphics.drawLine(n + 1, ++n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
        ++n8;
        if (this.isActive) {
            graphics.setColor(Theme.frameLightColor.getColor());
        } else {
            graphics.setColor(Theme.frameLightDisabledColor.getColor());
        }
        graphics.drawLine(n + 1, n8, n + 2, n8);
        graphics.drawLine(n + n3 - 2, n8, n + n3 - 3, n8);
    }

    public Insets getBorderInsets(Component component) {
        Frame frame;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null && window instanceof Frame && (frame = (Frame)window).getExtendedState() == (frame.getExtendedState() | 6)) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(0, 3, 3, 3);
    }

    static {
        theRect = new Rectangle();
    }
}

