/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyToolButtonBorder
extends AbstractBorder {
    protected static final Insets insets = new Insets(1, 1, 1, 1);

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawXpBorder(component, graphics, n, n2, n3, n4);
    }

    private void drawXpBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        AbstractButton abstractButton = (AbstractButton)component;
        ColorUIResource colorUIResource = null;
        boolean bl2 = Boolean.TRUE.equals(abstractButton.getClientProperty("isFileChooserButton"));
        boolean bl3 = bl = abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed();
        if (abstractButton.getModel().isPressed()) {
            if (bl) {
                colorUIResource = Theme.toolBorderPressedColor.getColor();
            } else if (abstractButton.isSelected()) {
                colorUIResource = Theme.toolBorderSelectedColor.getColor();
            } else {
                if (bl2) {
                    return;
                }
                colorUIResource = Theme.toolBorderColor.getColor();
            }
        } else if (bl) {
            colorUIResource = abstractButton.isSelected() ? Theme.toolBorderSelectedColor.getColor() : Theme.toolBorderRolloverColor.getColor();
        } else if (abstractButton.isSelected()) {
            colorUIResource = Theme.toolBorderSelectedColor.getColor();
        } else {
            if (bl2) {
                return;
            }
            colorUIResource = Theme.toolBorderColor.getColor();
        }
        DrawRoutines.drawRoundedBorder(graphics, colorUIResource, n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        if (!(component instanceof AbstractButton)) {
            return insets;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            return Theme.toolMargin;
        }
        Insets insets = abstractButton.getMargin();
        return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
    }
}

