/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartPanelPlus
extends ChartPanel
implements ChartMouseListener {
    String[] designs;
    String[] axis;
    static String url;
    LookAtDatabase lad;
    String[] measures;
    String[] units;
    Double[] xMultiplier;
    Double[] yMultiplier;

    final void initGlobals(String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        if (axis.length != 2) {
            throw new IllegalArgumentException("Two axis have to be defined");
        }
        this.designs = designs;
        this.axis = axis;
        ChartPanelPlus.url = url;
        this.measures = measures;
        this.units = units;
        this.lad = new LookAtDatabase(url);
        this.xMultiplier = (Double[])xMultiplier.clone();
        this.yMultiplier = (Double[])yMultiplier.clone();
    }

    public void plotEfficientFrontier(double granularity, EPAComplexTool.efficientFrontierSlope frontierSlope) {
        int i;
        if (granularity <= 0.0) {
            throw new IllegalArgumentException("Granularity must be a positive non null value!");
        }
        int numberOfDatapoints = super.getChart().getXYPlot().getDataset(0).getItemCount(0);
        double Xrange = Math.abs(super.getChart().getXYPlot().getDataset(0).getXValue(0, numberOfDatapoints - 1) - super.getChart().getXYPlot().getDataset(0).getXValue(0, 0));
        double Yrange = Math.abs(super.getChart().getXYPlot().getDataset(0).getYValue(0, numberOfDatapoints - 1) - super.getChart().getXYPlot().getDataset(0).getYValue(0, 0));
        XYSeries frontierDataSeries = new XYSeries((Comparable)((Object)"Series 0"));
        double[] firstCandidate = new double[]{0.0, super.getChart().getXYPlot().getDataset(0).getXValue(0, 0), super.getChart().getXYPlot().getDataset(0).getYValue(0, 0)};
        double[] lastCandidate = new double[]{numberOfDatapoints - 1, super.getChart().getXYPlot().getDataset(0).getXValue(0, numberOfDatapoints - 1), super.getChart().getXYPlot().getDataset(0).getYValue(0, numberOfDatapoints - 1)};
        ArrayList<double[]> window = new ArrayList<double[]>();
        ArrayList<double[]> window2 = new ArrayList<double[]>();
        ArrayList<Object> frontierPoints = new ArrayList<Object>();
        ArrayList frontierPoints2 = new ArrayList();
        frontierPoints.add(firstCandidate);
        window.add(firstCandidate);
        window2.add(firstCandidate);
        double smallestDistance = Xrange;
        for (i = 0; i < numberOfDatapoints - 1; ++i) {
            double temp = Math.abs(super.getChart().getXYPlot().getDataset(0).getXValue(0, i + 1) - super.getChart().getXYPlot().getDataset(0).getXValue(0, i));
            if (!(temp < smallestDistance) || !(temp > 0.0)) continue;
            smallestDistance = temp;
        }
        double windowSize = Xrange * ((100.0 - granularity) / 100.0) / 5.0 + smallestDistance * (granularity / 100.0) * 0.999;
        i = 1;
        while (i < numberOfDatapoints) {
            int j;
            double[] newCandidate = new double[]{i, super.getChart().getXYPlot().getDataset(0).getXValue(0, i), super.getChart().getXYPlot().getDataset(0).getYValue(0, i)};
            if (window.isEmpty() || ((double[])window.get(0))[1] + windowSize > newCandidate[1]) {
                window.add(newCandidate);
                window2.add(newCandidate);
                ++i;
            }
            if (!(((double[])window.get(0))[1] + windowSize < newCandidate[1]) && i != numberOfDatapoints - 1) continue;
            if (frontierSlope == EPAComplexTool.efficientFrontierSlope.POSITIVE) {
                int windowMaximum = 0;
                for (j = 0; j < window.size(); ++j) {
                    if (!(((double[])window.get(j))[2] > ((double[])window.get(windowMaximum))[2])) continue;
                    windowMaximum = j;
                }
                frontierPoints.add(window.get(windowMaximum));
            } else {
                int windowMinimum = 0;
                while (j < window.size()) {
                    if (((double[])window.get(j))[2] < ((double[])window.get(windowMinimum))[2]) {
                        windowMinimum = j;
                    }
                    ++j;
                }
                frontierPoints.add(window.get(windowMinimum));
            }
            window.clear();
            window.add(newCandidate);
        }
        frontierPoints.add(lastCandidate);
        frontierPoints2.add(frontierPoints.get(0));
        for (i = 1; i < frontierPoints.size(); ++i) {
            int j = (int)((double[])frontierPoints.get(i))[0];
            int k = 0;
            int winnerIndex = 0;
            double x0 = ((double[])frontierPoints.get(i - 1))[1];
            double x1 = ((double[])frontierPoints.get(i))[1];
            double y0 = ((double[])frontierPoints.get(i - 1))[2];
            double y1 = ((double[])frontierPoints.get(i))[2];
            double currentSlope = (y1 - y0) / (x1 - x0);
            block5: do {
                if (winnerIndex != 0) {
                    frontierPoints2.add(window2.get(winnerIndex));
                }
                x0 = ((double[])frontierPoints2.get(frontierPoints2.size() - 1))[1];
                y0 = ((double[])frontierPoints2.get(frontierPoints2.size() - 1))[2];
                x1 = ((double[])frontierPoints.get(i))[1];
                y1 = ((double[])frontierPoints.get(i))[2];
                currentSlope = (y1 - y0) / (x1 - x0);
                k = (int)((double[])frontierPoints2.get(frontierPoints2.size() - 1))[0];
                while (!window2.isEmpty() && k < j) {
                    y1 = ((double[])window2.get(++k))[2];
                    x1 = ((double[])window2.get(k))[1];
                    if (x1 == x0) continue block5;
                    double newSlope = (y1 - y0) / (x1 - x0);
                    if (frontierSlope == EPAComplexTool.efficientFrontierSlope.POSITIVE) {
                        if (!(newSlope > currentSlope)) continue;
                        currentSlope = newSlope;
                        winnerIndex = k;
                        continue;
                    }
                    if (!(newSlope < currentSlope)) continue;
                    currentSlope = newSlope;
                    winnerIndex = k;
                }
            } while (winnerIndex != 0 && !window2.isEmpty() && ((double[])frontierPoints2.get(frontierPoints2.size() - 1))[1] != ((double[])window2.get(winnerIndex))[1]);
            frontierPoints2.add(frontierPoints.get(i));
        }
        for (int j = 0; j < frontierPoints2.size(); ++j) {
            frontierDataSeries.add(((double[])frontierPoints2.get(j))[1], ((double[])frontierPoints2.get(j))[2]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection(frontierDataSeries);
        super.getChart().getXYPlot().setDataset(1, (XYDataset)dataset);
        XYLineAndShapeRenderer renderer0 = (XYLineAndShapeRenderer)super.getChart().getXYPlot().getRenderer(0);
        XYSmoothLineAndShapeRenderer renderer1 = new XYSmoothLineAndShapeRenderer();
        renderer1.setUseFillPaint(true);
        renderer1.setUseOutlinePaint(true);
        renderer1.setSeriesLinesVisible(0, true);
        renderer1.setSeriesShapesVisible(0, true);
        renderer1.setSeriesShapesFilled(0, true);
        renderer1.setSeriesShape(0, renderer1.getBaseShape());
        renderer1.setSeriesFillPaint(0, Color.RED);
        super.getChart().getXYPlot().setRenderer(0, (XYItemRenderer)renderer0);
        super.getChart().getXYPlot().setRenderer(1, (XYItemRenderer)renderer1);
    }

    public ChartPanelPlus(JFreeChart chart, String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        super(chart);
        this.addChartMouseListener(this);
        this.initGlobals(designs, axis, measures, units, xMultiplier, yMultiplier, url);
    }

    public ChartPanelPlus(JFreeChart chart, boolean useBuffer, String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        super(chart, useBuffer);
        this.addChartMouseListener(this);
        this.initGlobals(designs, axis, measures, units, xMultiplier, yMultiplier, url);
    }

    public ChartPanelPlus(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        super(chart, properties, save, print, zoom, tooltips);
        this.addChartMouseListener(this);
        this.initGlobals(designs, axis, measures, units, xMultiplier, yMultiplier, url);
    }

    public ChartPanelPlus(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.addChartMouseListener(this);
        this.initGlobals(designs, axis, measures, units, xMultiplier, yMultiplier, url);
    }

    public ChartPanelPlus(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips, String[] designs, String[] axis, String[] measures, String[] units, Double[] xMultiplier, Double[] yMultiplier, String url) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom, tooltips);
        this.addChartMouseListener(this);
        this.initGlobals(designs, axis, measures, units, xMultiplier, yMultiplier, url);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        boolean foundDataPoint = false;
        String outputInfoText = new String("");
        int x = event.getTrigger().getX();
        int y = event.getTrigger().getY();
        ChartPanel chartPanel = (ChartPanel)event.getTrigger().getComponent();
        Point2D p = chartPanel.translateScreenToJava2D(new Point(x, y));
        XYPlot plot = event.getChart().getXYPlot();
        Rectangle2D dataArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double xx = plot.getDomainAxis().java2DToValue(p.getX(), dataArea, plot.getDomainAxisEdge());
        double yy = plot.getRangeAxis().java2DToValue(p.getY(), dataArea, plot.getRangeAxisEdge());
        double ratio = (double)chartPanel.getHeight() / (double)chartPanel.getWidth();
        double xtolerance = plot.getDomainAxis().getRange().getLength() * ratio / 80.0;
        double ytolerance = plot.getRangeAxis().getRange().getLength() / 80.0;
        LegendItemCollection a = plot.getLegendItems();
        while (((XYPlot)chartPanel.getChart().getPlot()).getAnnotations().size() > 0) {
            ((XYPlot)chartPanel.getChart().getPlot()).removeAnnotation((XYAnnotation)((XYPlot)chartPanel.getChart().getPlot()).getAnnotations().get(0));
        }
        Utils ut = new Utils();
        ArrayList<double[][]> dataInformation = new ArrayList<double[][]>();
        ArrayList<Object> columnNames = new ArrayList();
        ArrayList<Object> ResultsColumnNames = new ArrayList();
        double[][] emptyResult = new double[0][0];
        for (int i = 0; i < this.designs.length; ++i) {
            String design = ut.replaceDashUnderscore(this.designs[i]);
            double xAxis = xx / this.xMultiplier[i];
            double yAxis = yy / this.yMultiplier[i];
            double xToleranceUnscaled = xtolerance / this.xMultiplier[i];
            double yToleranceUnscaled = ytolerance / this.yMultiplier[i];
            String condition = "\"" + this.axis[0] + "\" < " + Double.toString(xAxis + xToleranceUnscaled) + " AND " + "\"" + this.axis[0] + "\" > " + Double.toString(xAxis - xToleranceUnscaled) + " AND " + "\"" + this.axis[1] + "\" < " + Double.toString(yAxis + yToleranceUnscaled) + " AND " + "\"" + this.axis[1] + "\" > " + Double.toString(yAxis - yToleranceUnscaled);
            double[][] result = this.lad.LookAtDatabase2dDoubleArray("SELECT \"" + this.axis[0] + "\", \"" + this.axis[1] + "\" FROM APP." + design + " WHERE " + condition);
            if (result != null && result.length > 0) {
                for (int j = 0; j < result.length; ++j) {
                    result[j][0] = result[j][0] * this.xMultiplier[i];
                    result[j][1] = result[j][1] * this.yMultiplier[i];
                }
                dataInformation.add(result);
                foundDataPoint = true;
                continue;
            }
            dataInformation.add(emptyResult);
        }
        if (!foundDataPoint) {
            return;
        }
        double[] closestValue = new double[]{0.0, 0.0, xtolerance + ytolerance};
        for (int i = 0; i < dataInformation.size(); ++i) {
            if (((double[][])dataInformation.get(i)).length <= 0) continue;
            for (int j = 0; j < ((double[][])dataInformation.get(i)).length; ++j) {
                double distance = Math.pow((xx - ((double[][])dataInformation.get(i))[j][0]) / plot.getDomainAxis().getRange().getLength(), 2.0) + Math.pow((yy - ((double[][])dataInformation.get(i))[j][1]) / plot.getRangeAxis().getRange().getLength(), 2.0);
                if (!(distance < closestValue[2])) continue;
                closestValue[0] = i;
                closestValue[1] = j;
                closestValue[2] = distance;
            }
        }
        int screenX = event.getTrigger().getXOnScreen();
        int screenY = event.getTrigger().getYOnScreen();
        outputInfoText = this.designs[(int)closestValue[0]] + ": \n\r" + this.axis[0] + ": " + Double.toString((double)Math.round(((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] * 10000.0) / 10000.0) + ", " + this.axis[1] + ": " + Double.toString((double)Math.round(((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] * 10000.0) / 10000.0);
        double[] polygon = new double[]{((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] - xtolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] - ytolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] + xtolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] - ytolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] + xtolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] + ytolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] - xtolerance, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] + ytolerance};
        XYShapeAnnotation annotation = new XYShapeAnnotation((Shape)new Ellipse2D.Double(((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] - xtolerance * 2.5 / 2.0, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] - ytolerance * 2.5 / 2.0, xtolerance * 2.5, ytolerance * 2.5));
        XYPointerAnnotation annotation2 = new XYPointerAnnotation(outputInfoText, ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0], ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1], 10.0);
        annotation2.setLabelOffset(annotation2.getLabelOffset() * 5.0);
        annotation2.setFont(new Font("Arial", 0, 12));
        ((XYPlot)chartPanel.getChart().getPlot()).addAnnotation((XYAnnotation)annotation);
        ((XYPlot)chartPanel.getChart().getPlot()).addAnnotation((XYAnnotation)annotation2);
        columnNames = this.lad.GetDatabaseColumnsAll("SELECT * FROM APP." + ut.replaceDashUnderscore(this.designs[(int)closestValue[0]]));
        double[][] dataPoint = this.lad.LookAtDatabase2dDoubleArray("SELECT * FROM APP." + ut.replaceDashUnderscore(this.designs[(int)closestValue[0]]) + " WHERE \"" + this.axis[0] + "\" = " + ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][0] / this.xMultiplier[(int)closestValue[0]] + " AND \"" + this.axis[1] + "\" = " + ((double[][])dataInformation.get((int)closestValue[0]))[(int)closestValue[1]][1] / this.yMultiplier[(int)closestValue[0]]);
        outputInfoText = this.designs[(int)closestValue[0]] + ":";
        for (int i = 0; i < columnNames.size(); ++i) {
            int k;
            String measuresQuery = "SELECT * FROM APP.RESULTS WHERE TABNAME = '" + ut.replaceDashUnderscore(this.designs[(int)closestValue[0]]) + "'";
            ArrayList<String[]> multipliers = this.lad.LookAtDatabaseArray(measuresQuery);
            ResultsColumnNames = this.lad.GetDatabaseColumnsAll("SELECT * FROM APP.RESULTS");
            for (k = 0; k < ResultsColumnNames.size(); ++k) {
                if (!((String)ResultsColumnNames.get(k)).equalsIgnoreCase((String)columnNames.get(i))) continue;
                double[] dArray = dataPoint[0];
                int n = i;
                dArray[n] = dArray[n] * Double.parseDouble(multipliers.get(0)[k]);
                dataPoint[0][i] = (double)Math.round(dataPoint[0][i] * 10000.0) / 10000.0;
            }
            outputInfoText = outputInfoText + " \n\r " + (String)columnNames.get(i) + ": " + Double.toString(dataPoint[0][i]);
            for (k = 0; k < this.measures.length; ++k) {
                if (!((String)columnNames.get(i)).equalsIgnoreCase(this.measures[k])) continue;
                outputInfoText = outputInfoText + " " + this.units[k];
            }
        }
        if (outputInfoText.length() > 0) {
            JOptionPane infoPane = new JOptionPane(outputInfoText, 1, -1);
            JOptionPane.showMessageDialog((Component)chartPanel, outputInfoText, "Data Information", 1);
            infoPane.setVisible(true);
        }
        annotation2.setToolTipText(outputInfoText);
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }
}

