/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.jdbc.JDBCCategoryDataset;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePlot {
    static double IntegralValue = 0.0;
    static double[][] fueling_points;
    static String url;
    static Connection con;
    static String[] measures;
    static String[] units;
    static boolean showAbsoluteValues;

    public CreatePlot(String path, boolean showAbsoluteValues) {
        url = path;
        CreatePlot.showAbsoluteValues = showAbsoluteValues;
    }

    public CreatePlot(String path) {
        url = path;
        showAbsoluteValues = true;
    }

    private static JFreeChart createChart(XYDataset dataset, int count, String[] selectedItems, String X, String Y, ArrayList<Paint> pcolor, int ip, ArrayList<Boolean> cons, Float transparency) {
        ValueAxis axis2;
        double serMax;
        double serMin;
        ValueAxis axis;
        Utils ut = new Utils();
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Monte Carlo Results", (String)ut.removeComma(X), (String)ut.removeComma(Y), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        if (ip > 0) {
            chart.setTitle(new TextTitle("Plot " + Integer.toString(ip + 1) + ": Monte Carlo Results", new Font("Arial", 1, 12)));
        } else {
            chart.setTitle(new TextTitle("Monte Carlo Results", new Font("Arial", 1, 12)));
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setNoDataMessage("NO DATA");
        plot.setDomainZeroBaselineVisible(false);
        plot.setRangeZeroBaselineVisible(false);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setForegroundAlpha(transparency.floatValue());
        XYSeriesCollection dataset2 = (XYSeriesCollection)dataset;
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setUseFillPaint(true);
        renderer.setUseOutlinePaint(true);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShapesFilled(0, true);
        if (dataset2 != null && dataset2.getItemCount(0) > 0) {
            axis = plot.getDomainAxis();
            serMin = dataset2.getSeries(0).getMinX();
            serMax = dataset2.getSeries(0).getMaxX();
            axis.setRange(0.95 * serMin, 1.05 * serMax);
            axis2 = plot.getRangeAxis();
            serMin = dataset2.getSeries(0).getMinY();
            serMax = dataset2.getSeries(0).getMaxY();
            axis2.setRange(0.95 * serMin, 1.05 * serMax);
        }
        if (pcolor != null) {
            renderer.setSeriesOutlinePaint(0, pcolor.get(0));
            renderer.setSeriesFillPaint(0, pcolor.get(0));
        }
        int countSeries = 0;
        if (dataset != null) {
            countSeries = dataset.getSeriesCount();
        }
        for (int i = 1; i < countSeries; ++i) {
            renderer.setSeriesLinesVisible(i, false);
            renderer.setSeriesShapesVisible(i, true);
            renderer.setSeriesShapesFilled(i, true);
            renderer.setSeriesShape(i, renderer.getBaseShape());
            if (i < count) {
                renderer.setSeriesOutlinePaint(i, pcolor.get(i));
                renderer.setSeriesFillPaint(i, pcolor.get(i));
            } else {
                renderer.setSeriesOutlinePaint(i, pcolor.get(i - count));
                renderer.setSeriesFillPaint(i, (Paint)Color.WHITE);
            }
            if (dataset2.getSeries(i).getItemCount() <= 1) continue;
            axis = plot.getDomainAxis();
            double xmin = axis.getLowerBound();
            double xmax = axis.getUpperBound();
            serMin = dataset2.getSeries(i).getMinX();
            serMax = dataset2.getSeries(i).getMaxX();
            double setMin = xmin;
            double setMax = xmax;
            if (xmin > 0.95 * serMin) {
                setMin = 0.95 * serMin;
            }
            if (xmax < 1.05 * serMax) {
                setMax = 1.05 * serMax;
            }
            axis.setRange(setMin, setMax);
            axis2 = plot.getRangeAxis();
            xmin = axis2.getLowerBound();
            xmax = axis2.getUpperBound();
            serMin = dataset2.getSeries(i).getMinY();
            serMax = dataset2.getSeries(i).getMaxY();
            setMin = xmin;
            setMax = xmax;
            if (xmin > 0.95 * serMin) {
                setMin = 0.95 * serMin;
            }
            if (xmax < 1.05 * serMax) {
                setMax = 1.05 * serMax;
            }
            axis2.setRange(setMin, setMax);
        }
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private static XYDataset readData(String query, String[] selected, ArrayList<Boolean> cons, String x_label, String y_label, Double[] xMultiplier, Double[] yMultiplier) {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, "EPA", "EPA");
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        JDBCXYDataset jdbcData = null;
        XYSeriesCollection dataset = new XYSeriesCollection();
        try {
            int j;
            int i;
            Utils ut = new Utils();
            LookAtDatabase lad = new LookAtDatabase(url);
            jdbcData = new JDBCXYDataset(con);
            ArrayList limits = new ArrayList();
            for (i = 0; i < selected.length; ++i) {
                String restOfQuery = ut.replaceDashUnderscore(selected[i]);
                ArrayList<String> consArray = lad.LookAtDatabaseColumn("SELECT * FROM APP." + restOfQuery + "_CONSED");
                jdbcData.executeQuery(query + restOfQuery);
                xMultiplier[i] = new Double(1.0);
                yMultiplier[i] = new Double(1.0);
                if (showAbsoluteValues) {
                    for (int k = 0; k < 11; ++k) {
                        String measuresQuery;
                        if (x_label.equalsIgnoreCase(measures[k])) {
                            measuresQuery = "SELECT * FROM APP.RESULTS WHERE TABNAME = '" + restOfQuery + "'";
                            xMultiplier[i] = Double.parseDouble(lad.LookAtDatabaseForValue(measuresQuery, measures[k]));
                        }
                        if (!y_label.equalsIgnoreCase(measures[k])) continue;
                        measuresQuery = "SELECT * FROM APP.RESULTS WHERE TABNAME = '" + restOfQuery + "'";
                        yMultiplier[i] = Double.parseDouble(lad.LookAtDatabaseForValue(measuresQuery, measures[k]));
                    }
                }
                XYSeries series = new XYSeries((Comparable)((Object)("Series" + Integer.toString(i))));
                for (j = 0; j < jdbcData.getItemCount(); ++j) {
                    if (consArray.contains(Integer.toString(j))) continue;
                    series.add(jdbcData.getXValue(0, j) * xMultiplier[i], jdbcData.getYValue(0, j) * yMultiplier[i]);
                }
                dataset.addSeries(series);
            }
            for (i = 0; i < selected.length; ++i) {
                XYSeries series = new XYSeries((Comparable)((Object)("Series" + Integer.toString(i))));
                if (cons.get(i).booleanValue()) {
                    String restOfQuery = ut.replaceDashUnderscore(selected[i]);
                    ArrayList<String> consArray = lad.LookAtDatabaseColumn("SELECT * FROM APP." + restOfQuery + "_CONSED");
                    jdbcData.executeQuery(query + restOfQuery);
                    for (j = 0; j < jdbcData.getItemCount(); ++j) {
                        if (!consArray.contains(Integer.toString(j))) continue;
                        series.add(jdbcData.getXValue(0, j) * xMultiplier[i], jdbcData.getYValue(0, j) * yMultiplier[i]);
                    }
                }
                dataset.addSeries(series);
            }
            con.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(CreatePlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataset;
    }

    public JDBCCategoryDataset getDataInfo(String query) {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, "EPA", "EPA");
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        JDBCCategoryDataset jdbcData = null;
        try {
            jdbcData = new JDBCCategoryDataset(con);
            jdbcData.executeQuery(query);
            con.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(CreatePlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jdbcData;
    }

    public JDBCXYDataset getSeriesInfo(String query) {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, "EPA", "EPA");
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        JDBCXYDataset jdbcData = null;
        try {
            jdbcData = new JDBCXYDataset(con);
            jdbcData.executeQuery(query);
            con.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(CreatePlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jdbcData;
    }

    public static JPanel createPanel(int count, String[] selected, String xquery, String yquery, ArrayList<Paint> colorList, int i, ArrayList<Boolean> cons, Float transparency) {
        JFreeChart chart;
        Double[] yMultiplier;
        Double[] xMultiplier;
        String Xxq = "\"" + xquery + "\"";
        String Yyq = "\"" + yquery + "\"";
        String[] axis = new String[2];
        String[] axis_label = new String[2];
        axis[0] = xquery;
        axis[1] = yquery;
        axis_label[0] = axis[0];
        axis_label[1] = axis[1];
        double[] a = new double[]{1.0, 2.0};
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < measures.length; ++k) {
                if (!axis[j].equalsIgnoreCase(measures[k])) continue;
                int n = j;
                axis_label[n] = axis_label[n] + " " + units[k];
            }
        }
        Utils ut = new Utils();
        if (selected != null) {
            String partOfQuery = "SELECT " + Xxq + ", " + Yyq + " FROM APP.";
            xMultiplier = new Double[selected.length];
            yMultiplier = new Double[selected.length];
            chart = CreatePlot.createChart(CreatePlot.readData(partOfQuery, selected, cons, xquery, yquery, xMultiplier, yMultiplier), count, selected, axis_label[0], axis_label[1], colorList, i, cons, transparency);
        } else {
            xMultiplier = new Double[1];
            yMultiplier = new Double[1];
            xMultiplier[0] = new Double(1.0);
            yMultiplier[0] = new Double(1.0);
            chart = CreatePlot.createChart(null, count, selected, axis_label[0], axis_label[1], colorList, i, cons, transparency);
        }
        ChartPanelPlus chartPanel = new ChartPanelPlus(chart, selected, axis, measures, units, xMultiplier, yMultiplier, url);
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        chartPanel.setDisplayToolTips(true);
        chart.removeLegend();
        return chartPanel;
    }

    static {
        measures = new String[]{"DISPLACEMENT", "FDR", "AERO", "WEIGHT", "ENGEFF", "DRIVELINEFF", "ELOAD", "EMSIZE", "EMEFF", "RVALUE", "ROLLING", "FTP", "HWFET", "US06", "Combined [FTP-HWFET]", "FTP [CO2]", "HWFET [CO2]", "US06 [CO2]", "Combined [FTP-HWFET][CO2]", "0-10 mph", "0-30 mph", "0-50 mph", "0-60 mph", "0-70 mph", "30-50 mph", "50-70 mph", "Top Speed at 5% grade", "Top Speed at 10% grade", "Velocity at 1.3 s", "Velocity at 3 s", "Distance at 1.3 s", "Distance at 3 s", "60/70 mph grade at CGW"};
        units = new String[]{"[l]", "", "[m2 ]", "[kg]", "", "", "", "[kW]", "", "[\u03a9]", "", "[mpg]", "[mpg]", "[mpg]", "[mpg]", "[g CO2/mi]", "[g CO2/mi]", "[g CO2/mi]", "[g CO2/mi]", "[s]", "[s]", "[s]", "[s]", "[s]", "[s]", "[s]", "[mph]", "[mph]", "[mph]", "[mph]", "[mph]", "[mph]", "[%]"};
    }
}

