/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DataImporter
extends JFrame {
    String WORKING_PATH = "";
    String DataURL;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JComboBox jComboBox5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPasswordField jPasswordField1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public DataImporter(String path) {
        this.initComponents();
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.DataURL = path;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("banner.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setIconImage(image);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPasswordField1 = new JPasswordField();
        this.jLabel1 = new JLabel();
        this.jButton3 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton4 = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBox4 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jTextField2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jComboBox5 = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Import into Database");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Password:");
        this.jButton3.setText("Import");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImporter.this.jButton3ActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton4.setText("Login");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImporter.this.jButton4ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("CLASS:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"SMALL_CAR", "STANDARD_CAR", "SMALL_MPV", "FULL_SIZE_CAR", "LARGE_MPV", "TRUCK", "LARGE_TRUCK"}));
        this.jComboBox1.setEnabled(false);
        this.jLabel3.setText("ARCHITECTURE:");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Conventional SS", "Hybrid P2", "Hybrid PS"}));
        this.jComboBox2.setEnabled(false);
        this.jLabel4.setText("ENGINE:");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "Baseline", "Atkinson_CPS", "Atkinson_DVA", "Stoich_DI_Turbo", "Lean_DI_Turbo", "EGR_DI_Turbo", "2010_Diesel", "2020_Diesel"}));
        this.jComboBox3.setEnabled(false);
        this.jLabel5.setText("TRANSMISSION:");
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "6AT_2010", "6AT_2020", "8AT_2020", "6Dry_DCT", "8Dry_DCT", "8Wet_DCT", "PowerSplit"}));
        this.jComboBox4.setEnabled(false);
        this.jLabel6.setText("RICARDO FORMULA:");
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImporter.this.jButton1ActionPerformed(evt);
            }
        });
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Import from file");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImporter.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jRadioButton2.setText("Copy & Paste");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImporter.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jTextField2.setEnabled(false);
        this.jLabel7.setText("DUTY CYCLE:");
        this.jComboBox5.setModel(new DefaultComboBoxModel<String>(new String[]{"FTP", "HWFET", "US06", "0-10 mph", "0-30 mph", "0-50 mph", "0-60 mph", "0-70 mph", "30-50 mph", "50-70 mph", "Top Speed at 5% grade", "Top Speed at 10% grade", "Velocity at 1.3 s", "Velocity at 3 s", "Distance at 1.3 s", "Distance at 3 s", "60/70 mph grade at CGW"}));
        this.jComboBox5.setEnabled(false);
        this.jLabel8.setText("File:");
        this.jLabel9.setText("Formula:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel1).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBox3, GroupLayout.Alignment.LEADING, 0, 197, Short.MAX_VALUE).addComponent(this.jComboBox4, GroupLayout.Alignment.LEADING, 0, 197, Short.MAX_VALUE).addComponent(this.jComboBox2, 0, 197, Short.MAX_VALUE).addComponent(this.jComboBox1, GroupLayout.Alignment.LEADING, 0, 197, Short.MAX_VALUE).addComponent(this.jComboBox5, 0, 197, Short.MAX_VALUE)).addGap(91, 91, 91)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPasswordField1, -1, 197, Short.MAX_VALUE).addGap(22, 22, 22).addComponent(this.jButton4).addContainerGap()))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 380, Short.MAX_VALUE).addGap(14, 14, 14)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addContainerGap(292, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(61, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton3, -2, 118, -2).addGap(106, 106, 106)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9).addComponent(this.jLabel8)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2)).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField2, GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING, -2, 192, -2))).addGap(18, 18, 18).addComponent(this.jButton1))).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 384, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField1, -2, -1, -2).addComponent(this.jButton4).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox2, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox5, -2, -1, -2).addComponent(this.jLabel7)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addGap(18, 18, 18).addComponent(this.jScrollPane1, -2, 112, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.checkPasswd();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jTextField1.setEnabled(true);
        this.jButton1.setEnabled(true);
        this.jTextField2.setEnabled(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jTextField1.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.jTextField2.setEnabled(true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        String formulaString = null;
        boolean checkString = false;
        if (this.jRadioButton1.isSelected()) {
            formulaString = this.getFormulaFromFile(this.jTextField1.getText());
            this.jTextField2.setText(formulaString);
        } else if (this.jRadioButton2.isSelected()) {
            formulaString = this.getFormulaFromTextField(this.jTextField2.getText());
        }
        if (!formulaString.isEmpty()) {
            checkString = true;
        }
        if (checkString) {
            LookAtDatabase lad = new LookAtDatabase(this.DataURL);
            String upQuery = "select * from APP.FORMULA WHERE CLASS='" + this.jComboBox1.getSelectedItem() + "' AND ARCHITECTURE='" + this.jComboBox2.getSelectedItem() + "' AND ENGINE='" + this.jComboBox3.getSelectedItem() + "' AND TRANSMISSION='" + this.jComboBox4.getSelectedItem() + "' AND DUTYCYCLE='" + this.jComboBox5.getSelectedItem() + "'";
            ArrayList<String[]> upStr = lad.LookAtDatabaseForUpdate(upQuery);
            int success = 0;
            if (upStr.isEmpty()) {
                String insQuery = "INSERT INTO APP.FORMULA (\"CLASS\", ARCHITECTURE, ENGINE, TRANSMISSION, FORMULA, DUTYCYCLE)";
                String insQuery2 = " VALUES ('" + (String)this.jComboBox1.getSelectedItem() + "', '" + (String)this.jComboBox2.getSelectedItem() + "', '" + (String)this.jComboBox3.getSelectedItem() + "', '" + (String)this.jComboBox4.getSelectedItem() + "', '" + formulaString + "', '" + (String)this.jComboBox5.getSelectedItem() + "')";
                success = lad.PutToDatabase(insQuery + insQuery2);
            } else {
                String insQuery = "UPDATE APP.FORMULA SET FORMULA='" + formulaString + "'";
                String insQuery2 = " WHERE CLASS='" + this.jComboBox1.getSelectedItem() + "' AND ARCHITECTURE='" + this.jComboBox2.getSelectedItem() + "' AND ENGINE='" + this.jComboBox3.getSelectedItem() + "' AND TRANSMISSION='" + this.jComboBox4.getSelectedItem() + "' AND DUTYCYCLE='" + this.jComboBox5.getSelectedItem() + "'";
                success = lad.PutToDatabase(insQuery + insQuery2);
            }
            if (success > 0 & upStr.isEmpty()) {
                this.jTextArea1.append("Formula Inserted. \n");
                this.jTextArea1.append(formulaString);
            } else if (success > 0 & !upStr.isEmpty()) {
                this.jTextArea1.append("Formula Updated. \n");
                this.jTextArea1.append(formulaString);
            } else {
                this.jTextArea1.append("Nothing Inserted due to database contacting failure. \n");
            }
        } else {
            this.jTextArea1.append("Nothing Inserted. \n");
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int returnVal;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        if (!this.jTextField1.getText().isEmpty()) {
            fc.setCurrentDirectory(new File(this.jTextField1.getText()));
        } else if (!this.WORKING_PATH.isEmpty()) {
            fc.setCurrentDirectory(new File(this.WORKING_PATH));
        }
        DataImporter mainFrame = this;
        if (evt.getSource() == this.jButton1 && (returnVal = fc.showDialog(mainFrame, null)) == 0) {
            File file = fc.getSelectedFile();
            this.jTextField1.setText(file.getAbsolutePath());
            if (this.WORKING_PATH.isEmpty()) {
                this.WORKING_PATH = file.getParent();
            }
        }
    }

    private String getFormulaFromFile(String inFile) {
        String formulaString = "";
        File file = new File(inFile);
        if (file.exists()) {
            Utils rf = new Utils();
            formulaString = rf.ReadFormulaFile(inFile);
        } else {
            JOptionPane.showMessageDialog(this, "The file: " + file.getName() + " does not exist.\n\n");
        }
        return formulaString;
    }

    private String getFormulaFromTextField(String textField) {
        String outString = "";
        Utils readField = new Utils();
        outString = readField.removeDuplicateWhitespace(textField);
        outString = readField.removeNewLineMark(outString);
        outString = readField.removeColon(outString);
        return outString;
    }

    private void checkPasswd() {
        String password = "Ricardo2020";
        char[] ssPass = this.jPasswordField1.getPassword();
        String setPassword = new String(ssPass);
        String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        String timeOut = sdf.format(cal.getTime());
        if (password.equals(setPassword)) {
            this.jTextArea1.append("Password Correct! \n" + timeOut + "\n");
            this.jComboBox1.setEnabled(true);
            this.jComboBox2.setEnabled(true);
            this.jComboBox3.setEnabled(true);
            this.jComboBox4.setEnabled(true);
            this.jComboBox5.setEnabled(true);
            this.jButton3.setEnabled(true);
        } else {
            this.jTextArea1.append("Wrong Password! \n");
            this.jComboBox1.setEnabled(false);
            this.jComboBox2.setEnabled(false);
            this.jComboBox3.setEnabled(false);
            this.jComboBox4.setEnabled(false);
            this.jComboBox5.setEnabled(false);
            this.jButton3.setEnabled(false);
        }
    }
}

