/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTree
extends JPanel {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    public TreePath path;
    public String itemPath;

    public DynamicTree(String Name, boolean singleSelection) {
        super(new GridLayout(1, 0));
        this.rootNode = new DefaultMutableTreeNode(Name);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        if (singleSelection) {
            this.tree.getSelectionModel().setSelectionMode(1);
        } else {
            this.tree.getSelectionModel().setSelectionMode(4);
        }
        this.tree.setShowsRootHandles(true);
        this.path = this.tree.getSelectionPath();
        this.tree.getSelectionPath();
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            return;
        }
        this.toolkit.beep();
    }

    public DefaultMutableTreeNode addObject(Object child, TreePath parentPath) {
        DefaultMutableTreeNode parentNode = null;
        parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, child, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public void addSelectionListener() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                TreePath[] selections = DynamicTree.this.tree.getSelectionPaths();
                TreePath tp = event.getNewLeadSelectionPath();
                if (tp != null && tp.getLastPathComponent().toString() != null && ((DefaultMutableTreeNode)tp.getLastPathComponent()).isLeaf()) {
                    if (selections != null) {
                        DynamicTree.this.itemPath = tp.getLastPathComponent().toString();
                    }
                } else {
                    DynamicTree.this.itemPath = null;
                }
            }
        });
    }

    public ArrayList<TreeNode> getLimitedTreeContent() {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (root.getChildCount() > 0) {
            treeList.add(root.getChildAt(0));
            for (int i = 1; i < root.getChildCount(); ++i) {
                treeList.add(root.getChildAt(i));
            }
        }
        return treeList;
    }

    public ArrayList<TreeNode> getChildNodeContent(int nodeItem) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int childChildrenNum = root.getChildAt(nodeItem).getChildCount();
        if (childChildrenNum > 0) {
            treeList.add(root.getChildAt(nodeItem).getChildAt(0));
            for (int j = 1; j < childChildrenNum; ++j) {
                treeList.add(root.getChildAt(nodeItem).getChildAt(j));
            }
        }
        return treeList;
    }

    public int getNodeIndex(TreeNode node) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int index = root.getIndex(node);
        return index;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            e.getTreePath().getPathCount();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (Exception evt) {
                System.out.println(evt.toString());
            }
            Utils ut = new Utils();
            node.setUserObject(ut.removeDuplicateWhitespace(node.getUserObject().toString()));
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + node.getUserObject());
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

