/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAtDatabase {
    Statement stmt;
    Connection con;
    String url;

    public LookAtDatabase(String pathToData) {
        this.url = pathToData;
    }

    public boolean TrialConnect() {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            this.stmt.close();
            this.con.close();
            return true;
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
            return false;
        }
    }

    public ArrayList<String> LookAtDatabaseRow(String query) {
        ArrayList<String> lookValue = new ArrayList<String>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            while (rs.next()) {
                String rowValue = rs.getString(1);
                if (rowValue == null) continue;
                lookValue.add(rowValue);
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public String LookAtDatabaseForValue(String query, String colID) {
        String lookValue = "";
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            while (rs.next()) {
                String rowValue;
                lookValue = rowValue = rs.getString(colID);
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public ArrayList<String> LookAtDatabaseColumn(String query) {
        ArrayList<String> lookValue = new ArrayList<String>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= numberOfColumns; ++i) {
                    String columnValue = rs.getString(i);
                    lookValue.add(columnValue);
                }
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public ArrayList<String[]> LookAtDatabaseArray(String query) {
        ArrayList<String[]> lookValue = new ArrayList<String[]>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                String[] columnValue = new String[numberOfColumns];
                for (int i = 1; i <= numberOfColumns; ++i) {
                    columnValue[i - 1] = rs.getString(i);
                }
                lookValue.add(columnValue);
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public ArrayList<double[]> LookAtDatabaseDoubleArray(String query) {
        ArrayList<double[]> lookValue = new ArrayList<double[]>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                double[] columnValue = new double[numberOfColumns];
                for (int i = 1; i <= numberOfColumns; ++i) {
                    columnValue[i - 1] = rs.getDouble(i);
                }
                lookValue.add(columnValue);
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public double[][] LookAtDatabase2dDoubleArray(String query) {
        double[][] lookValue = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            ArrayList<double[]> cacheArray = new ArrayList<double[]>();
            int j = 0;
            while (rs.next()) {
                cacheArray.add(new double[numberOfColumns]);
                for (int i = 0; i < numberOfColumns; ++i) {
                    ((double[])cacheArray.get((int)j))[i] = rs.getDouble(i + 1);
                }
                ++j;
            }
            lookValue = new double[cacheArray.size()][numberOfColumns];
            cacheArray.toArray((T[])lookValue);
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public ArrayList<String[]> LookAtDatabaseForUpdate(String query) {
        ArrayList<String[]> lookValue = new ArrayList<String[]>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                String[] columnValue = new String[numberOfColumns];
                for (int i = 1; i <= numberOfColumns; ++i) {
                    columnValue[i - 1] = rs.getString(i);
                }
                lookValue.add(columnValue);
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public String LookAtDatabaseForFormula(String query) {
        String lookValue = "";
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                String rowValue;
                lookValue = rowValue = rs.getString("FORMULA");
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return lookValue;
    }

    public int PutToDatabase(String query) {
        int inserted = 0;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            inserted = this.stmt.executeUpdate(query);
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return inserted;
    }

    public int PutArrayToDatabase(String query, double[] array) {
        int inserted = 0;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            for (int i = 0; i < array.length; ++i) {
                inserted = this.stmt.executeUpdate(query + " VALUES(" + Double.toString(array[i]) + ")");
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return inserted;
    }

    public ArrayList<String> GetDatabaseColumns(String query, int lim) {
        ArrayList<String> cols = new ArrayList<String>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            rs.next();
            if (lim > rsmd.getColumnCount()) {
                lim = rsmd.getColumnCount() + 1;
            }
            for (int i = 1; i < lim; ++i) {
                if (rsmd.getColumnName(i).contentEquals("IND") || rs.getString(i) == null) continue;
                cols.add(rsmd.getColumnName(i));
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return cols;
    }

    public ArrayList<String> GetDatabaseColumnsAll(String query) {
        ArrayList<String> cols = new ArrayList<String>();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            this.stmt = this.con.createStatement();
            ResultSet rs = this.stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            rs.next();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                cols.add(rsmd.getColumnName(i));
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return cols;
    }

    public boolean GetTableExistence(String schemaName, String tableName) {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.print("InstantiationException: ");
            System.err.println(ex.getMessage());
        }
        catch (IllegalAccessException exp) {
            System.err.print("IllegalAccessException: ");
            System.err.println(exp.getMessage());
        }
        try {
            this.con = DriverManager.getConnection(this.url, "EPA", "EPA");
            DatabaseMetaData metadata = this.con.getMetaData();
            String[] names = new String[]{"TABLE"};
            ResultSet res = metadata.getTables(null, schemaName, null, names);
            String tabNameCheck = tableName;
            while (res.next()) {
                String tab = res.getString("TABLE_NAME");
                if (!tab.matches(tabNameCheck.toUpperCase())) continue;
                this.con.close();
                return true;
            }
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.print("SQLException: ");
            System.err.println(ex.getMessage());
        }
        return false;
    }
}

