/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsDatabase
extends JFrame {
    DefaultTableModel tableModel = new DefaultTableModel();
    JTable table = new JTable(this.tableModel);
    String PathToData;
    boolean closeEvent = false;
    ArrayList<String> tableSelected = new ArrayList();
    ArrayList<String> tableInfoSelected = new ArrayList();
    ArrayList<String> tableDesignSelected = new ArrayList();
    ArrayList<String> tableDesignListSelected = new ArrayList();
    ArrayList<int[]> tableColorSelected = new ArrayList();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ResultsDatabase(String URL2) {
        this.PathToData = URL2;
        this.initComponents();
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("banner.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setIconImage(image);
        this.setTitle("Complex Tool Results Database");
        this.tableModel.addColumn("Design List");
        this.tableModel.addColumn("Design Name");
        this.tableModel.addColumn("Database Table");
        this.tableModel.addColumn("Modified");
        this.tableModel.addColumn("Info");
        this.jScrollPane1.setViewportView(this.table);
        LookAtDatabase look = new LookAtDatabase(URL2);
        ArrayList<String[]> list = look.LookAtDatabaseArray("SELECT * FROM APP.RESULTS");
        for (int i = 0; i < list.size(); ++i) {
            this.tableModel.addRow(list.get(i));
        }
        boolean ascending = false;
        this.sortColumn(this.tableModel, 3, ascending);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButton3.setText("Delete Selected");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsDatabase.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsDatabase.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Load & Close");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsDatabase.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addGap(60, 60, 60).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 413, Short.MAX_VALUE).addComponent(this.jButton3)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton3).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 746, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 231, Short.MAX_VALUE).addGap(14, 14, 14).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
        this.closeEvent = false;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int[] sc = this.table.getSelectedRows();
        for (int i = 0; i < sc.length; ++i) {
            int[] data = new int[3];
            this.tableDesignListSelected.add(this.tableModel.getValueAt(sc[i], 0).toString());
            this.tableDesignSelected.add(this.tableModel.getValueAt(sc[i], 1).toString());
            String tabNameSelected = this.tableModel.getValueAt(sc[i], 2).toString();
            this.tableSelected.add(tabNameSelected);
            String tabInfo = this.tableModel.getValueAt(sc[i], 4).toString();
            this.tableInfoSelected.add(tabInfo);
            String[] infoSplitter = tabInfo.split(";");
            for (int j = 0; j < infoSplitter.length; ++j) {
                if (!infoSplitter[j].startsWith("Color[")) continue;
                String[] infoSplitter2 = infoSplitter[j].split(",");
                for (int k = 0; k < infoSplitter2.length; ++k) {
                    String[] infoSplitter3 = infoSplitter2[k].split("=");
                    data[k] = Integer.parseInt(infoSplitter3[1].replace("]", ""));
                }
            }
            this.tableColorSelected.add(data);
        }
        this.closeEvent = true;
        this.dispose();
    }

    public ArrayList<int[]> getTableColorToLoad() {
        return this.tableColorSelected;
    }

    public ArrayList<String> getDatabaseTable() {
        return this.tableSelected;
    }

    public ArrayList<String> getTableInfoToLoad() {
        return this.tableInfoSelected;
    }

    public ArrayList<String> getTableDesignToLoad() {
        return this.tableDesignSelected;
    }

    public ArrayList<String> getTableDesigListToLoad() {
        return this.tableDesignListSelected;
    }

    public boolean getCloseEvent() {
        return this.closeEvent;
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int numSelected = this.table.getSelectedRowCount();
        int[] selectedRows = new int[numSelected];
        selectedRows = this.table.getSelectedRows();
        int totalRows = this.table.getRowCount();
        LookAtDatabase lad = new LookAtDatabase(this.PathToData);
        for (int i = numSelected - 1; i >= 0; --i) {
            String query = (String)this.tableModel.getValueAt(selectedRows[i], 2);
            String deleteQuery = "DROP TABLE APP." + query;
            lad.PutToDatabase(deleteQuery);
            if (lad.GetTableExistence("APP", query + "_CONS")) {
                deleteQuery = "DROP TABLE APP." + query + "_CONS";
                lad.PutToDatabase(deleteQuery);
            }
            if (lad.GetTableExistence("APP", query + "_CONSED")) {
                deleteQuery = "DROP TABLE APP." + query + "_CONSED";
                lad.PutToDatabase(deleteQuery);
            }
            deleteQuery = "DELETE FROM APP.RESULTS WHERE TABNAME = '" + query + "'";
            lad.PutToDatabase(deleteQuery);
            this.tableModel.removeRow(selectedRows[i]);
        }
    }

    public final void sortColumn(DefaultTableModel model, int colIndex, boolean ascending) {
        int i;
        Vector<Vector> data = model.getDataVector();
        Object[] colData = new Object[model.getRowCount()];
        for (i = 0; i < colData.length; ++i) {
            colData[i] = data.get(i).get(colIndex);
        }
        Arrays.sort(colData, new ColumnSorter(ascending));
        for (i = 0; i < colData.length; ++i) {
            data.get(i).set(colIndex, colData[i]);
        }
        model.fireTableStructureChanged();
    }

    public class ColumnSorter
    implements Comparator {
        boolean ascending;

        ColumnSorter(boolean ascending) {
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            if (a instanceof String && ((String)a).length() == 0) {
                a = null;
            }
            if (b instanceof String && ((String)b).length() == 0) {
                b = null;
            }
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)a).compareTo(b);
                }
                return ((Comparable)b).compareTo(a);
            }
            if (this.ascending) {
                return a.toString().compareTo(b.toString());
            }
            return b.toString().compareTo(a.toString());
        }
    }
}

