/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.java.dev.jspreadsheet.CellRange;
import net.java.dev.jspreadsheet.JSpreadsheet;

class SortDialog
extends JOptionPane {
    private JComboBox primary;
    private JComboBox tiebreaker;
    private JRadioButton ascending1;
    private JRadioButton ascending2;
    private JRadioButton descending1;
    private JRadioButton descending2;

    SortDialog(boolean byRow, CellRange range) {
        int i;
        Vector<String> first = new Vector<String>();
        Vector<String> second = new Vector<String>();
        second.add("None");
        if (byRow) {
            for (i = range.getStartRow(); i <= range.getEndRow(); ++i) {
                first.add("Row " + JSpreadsheet.translateRow(i));
                second.add("Row " + JSpreadsheet.translateRow(i));
            }
        } else {
            for (i = range.getStartCol(); i <= range.getEndCol(); ++i) {
                first.add("Column " + JSpreadsheet.translateColumn(i));
                second.add("Column " + JSpreadsheet.translateColumn(i));
            }
        }
        this.primary = new JComboBox(first);
        this.primary.setSelectedIndex(0);
        this.tiebreaker = new JComboBox(second);
        this.tiebreaker.setSelectedIndex(0);
        JPanel box = new JPanel();
        this.ascending1 = new JRadioButton("Ascending");
        this.descending1 = new JRadioButton("Descending");
        this.ascending2 = new JRadioButton("Ascending");
        this.descending2 = new JRadioButton("Descending");
        ButtonGroup group = new ButtonGroup();
        ButtonGroup group2 = new ButtonGroup();
        this.ascending1.setSelected(true);
        group.add(this.ascending1);
        group.add(this.descending1);
        this.ascending2.setSelected(true);
        group2.add(this.ascending2);
        group2.add(this.descending2);
        box.setLayout(new GridLayout(0, 3, 10, 5));
        JLabel sortLabel = new JLabel("Sort By:");
        sortLabel.setLabelFor(this.primary);
        sortLabel.setDisplayedMnemonic(83);
        this.ascending1.setMnemonic(65);
        this.descending1.setMnemonic(68);
        box.add(sortLabel);
        box.add(new JLabel(""));
        box.add(new JLabel(""));
        box.add(this.primary);
        box.add(this.ascending1);
        box.add(this.descending1);
        sortLabel = new JLabel("Then By:");
        sortLabel.setLabelFor(this.tiebreaker);
        sortLabel.setDisplayedMnemonic(84);
        this.ascending2.setMnemonic(67);
        this.descending2.setMnemonic(69);
        box.add(sortLabel);
        box.add(new JLabel(""));
        box.add(new JLabel(""));
        box.add(this.tiebreaker);
        box.add(this.ascending2);
        box.add(this.descending2);
        this.setMessage(box);
        this.setOptionType(2);
    }

    public int getCriteriaA() {
        return this.primary.getSelectedIndex();
    }

    public int getCriteriaB() {
        return this.tiebreaker.getSelectedIndex() - 1;
    }

    public boolean firstAscending() {
        return this.ascending1.isSelected();
    }

    public boolean secondAscending() {
        return this.ascending2.isSelected();
    }

    int show(Component parent, String title) {
        JDialog dlg = this.createDialog(parent, title);
        dlg.pack();
        dlg.setVisible(true);
        Object object = this.getValue();
        return object instanceof Integer ? (Integer)object : -1;
    }
}

