/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String ezanl = "ezanl";
    public static final String veh = "veh";
    public static final String xls = "xls";

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void WriteStringToFile(String inFile, ArrayList<String> saveString) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(inFile));
            try {
                for (int i = 0; i < saveString.size(); ++i) {
                    String stream = saveString.get(i);
                    out.write(stream + "\n");
                }
            }
            finally {
                out.flush();
                out.close();
            }
        }
        catch (IOException ex) {
            System.out.print(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> ReadFile(String inFile) {
        ArrayList<String> parsedAnalysisFile = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    parsedAnalysisFile.add(line);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            System.out.print(ex);
        }
        return parsedAnalysisFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ReadFormulaFile(String inFile) {
        String parsedAnalysisFile = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    parsedAnalysisFile = parsedAnalysisFile + this.removeColon(this.removeNewLineMark(this.removeDuplicateWhitespace(line)));
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            System.out.print(ex);
        }
        return parsedAnalysisFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] ReadFileGeneral(String inFile) {
        String[] parsedAnalysisFile = new String[3];
        try {
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            try {
                String line;
                int i = 0;
                while ((line = in.readLine()) != null) {
                    parsedAnalysisFile[i] = line;
                    ++i;
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            System.out.print(ex);
        }
        return parsedAnalysisFile;
    }

    public String removeNewLineMark(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = t + st.nextElement();
        }
        return t;
    }

    public String replaceDashUnderscore(String s) {
        StringTokenizer st = new StringTokenizer(s, "-", false);
        String t = "";
        int count = st.countTokens();
        int i = 0;
        while (st.hasMoreElements()) {
            if (count != ++i) {
                t = t + st.nextElement() + "_";
                continue;
            }
            t = t + st.nextElement();
        }
        return t;
    }

    public String removeDuplicateWhitespace(String inputStr) {
        String patternStr = "\\s+";
        String replaceStr = "";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    public String removeColon(String inputStr) {
        String patternStr = ":";
        String replaceStr = "";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    public String removeComma(String inputStr) {
        String patternStr = "\"";
        String replaceStr = "";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }
}

