/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.NetworkPolicyRuntime;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public final class FileIOPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime = FileIOPolicyRuntime.class$("com.trend.iwss.jscan.runtime.FileIOPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime);
    public static final String NAME = "FileIO";
    public static final String PROP_PREFIX = "file";
    public static final Factory FACT = new Factory("FileIO");
    public static final String ENC_BACKSLASH = "%5c%";
    public static final String CFG_FILEIO_CATEGORYSFX_STATE_BOOL = ".state";
    public static final String CFG_FILEIO_CATEGORYSFX_EXCLUDE_LIST = ".ex_list";
    public static final String CFG_FILEIO_CATEGORYSFX_INCLUDE_LIST = ".in_list";
    public static final Category CATEGORY_READ = new Category("read", "instr.action.file.read");
    public static final Category CATEGORY_WRITE = new Category("write", "instr.action.file.write");
    public static final Category CATEGORY_DESTRUCTIVE = new Category("destructive", "instr.action.file.destructive", "instr.action.file.destructive_alt");
    public static final Category CATEGORY_NONDESTRUCTIVE = new Category("nondestructive", "instr.action.file.nondestructive", "instr.action.file.nondestructive_alt");
    public static final Category CATEGORY_DONT_INSTRUMENT = new Category("dont_instrument", null);
    public static final Category CATEGORY_UNKNOWN = new Category("unknown", null);
    public static final String METH_INIT = "<init>";
    public static final String METH_CLINIT = "<clinit>";
    private static final MethodRefMatcher MATCH_FILE = MethodRefMatcher.make("java/io/File");
    private static final MethodRefMatcher MATCH_FILE_OBJECT_IGNORE = MethodRefMatcher.make("java/io/File", new String[]{"getClass", "clone", "wait", "finalize", "notify", "notifyAll"});
    private static final MethodRefMatcher MATCH_FILE_IGNORE = MethodRefMatcher.make("java/io/File", new String[]{"<init>", "<clinit>", "isAbsolute", "getAbsolutePath", "getAbsoluteFile", "getName", "compareTo", "getParent", "getParentFile", "getPath", "setReadOnly", "toURI", "toURL", "hashCode", "toString", "equals"});
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    private static final MethodRefMatcher MATCH_FILE_NONDESTRUCTIVE = MATCHERS.make("java/io/File", new String[]{"canRead", "canWrite", "exists", "isDirectory", "isFile", "lastModified", "length", "isHidden", "getCanonicalPath", "getCanonicalFile", "listRoots", "listFiles", "list"});
    private static final MethodRefMatcher MATCH_FILE_DESTRUCTIVE = MATCHERS.make("java/io/File", new String[]{"delete", "mkdir", "deleteOnExit", "mkdirs", "createNewFile", "createTempFile", "setLastModified", "renameTo"});
    private static final String[] ARGS_FILE_AND_STRING = new String[]{"(Ljava/io/File;*", "(Ljava/lang/String;*"};
    private static final MethodRefMatcher.Set READ_MATCHERS = MATCHERS.makeSet("java/io/");
    private static final MethodRefMatcher MATCH_READ_FIS = READ_MATCHERS.make("java/io/FileInputStream", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_READ_FR = READ_MATCHERS.make("java/io/FileReader", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_READ_RAF = READ_MATCHERS.make("java/io/RandomAccessFile", new String[]{"<init>", "read*", "seek", "skipBytes"});
    private static final MethodRefMatcher.Set WRITE_MATCHERS = MATCHERS.makeSet("java/io/");
    private static final MethodRefMatcher MATCH_WRITE_FOS = WRITE_MATCHERS.make("java/io/FileOutputStream", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_WRITE_FW = WRITE_MATCHERS.make("java/io/FileWriter", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_WRITE_RAF = WRITE_MATCHERS.make("java/io/RandomAccessFile", new String[]{"<init>", "write*", "setLength"});
    private static final MethodRefMatcher.Set PRE_MATCHERS_INIT = new MethodRefMatcher.Set("java/io/");
    private static final MethodRefMatcher PRE_MATCH_FIS_INIT = PRE_MATCHERS_INIT.make("java/io/FileInputStream", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FR_INIT = PRE_MATCHERS_INIT.make("java/io/FileReader", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FOS_INIT = PRE_MATCHERS_INIT.make("java/io/FileOutputStream", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FW_INIT = PRE_MATCHERS_INIT.make("java/io/FileWriter", "<init>");
    private static final MethodRefMatcher PRE_MATCH_RAF_INIT = PRE_MATCHERS_INIT.make("java/io/RandomAccessFile", "<init>");
    private static final MethodRefMatcher PRE_MATCH_URL_CONNECTION = MethodRefMatcher.make("java/net/URLConnection", new String[]{"<init>", "connect"});
    private static final MethodRefMatcher PRE_MATCH_URL = MethodRefMatcher.make("java/net/URL", new String[]{"<init>", "openConnection", "openStream", "getContent"});
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime;

    FileIOPolicyRuntime(Session session) {
        super(NAME, PROP_PREFIX, session);
    }

    public static void preFilter(CallContext callContext) {
        PolicyRuntime.preFilter(callContext, FACT);
    }

    public static void postFilter(CallContext callContext) {
        PolicyRuntime.postFilter(callContext, FACT);
    }

    public static Category getCategory(String string, String string2, String string3) {
        Category category = MATCH_FILE.match(string, string2, string3) ? (MATCH_FILE_IGNORE.match(string, string2, string3) ? CATEGORY_DONT_INSTRUMENT : (MATCH_FILE_OBJECT_IGNORE.match(string, string2, string3) ? CATEGORY_DONT_INSTRUMENT : (MATCH_FILE_DESTRUCTIVE.match(string, string2, string3) ? CATEGORY_DESTRUCTIVE : (MATCH_FILE_NONDESTRUCTIVE.match(string, string2, string3) ? CATEGORY_NONDESTRUCTIVE : CATEGORY_UNKNOWN)))) : (READ_MATCHERS.match(string, string2, string3) ? CATEGORY_READ : (WRITE_MATCHERS.match(string, string2, string3) ? CATEGORY_WRITE : null));
        return category;
    }

    void _preFilter(CallContext callContext) {
        URL uRL;
        String string;
        String string2 = callContext.getRefName();
        Category category = FileIOPolicyRuntime.getCategory(callContext.getClassName(), string2, callContext.getRefDesc());
        String string3 = null;
        if (MATCH_FILE.match(callContext)) {
            File file = (File)callContext.getTarget();
            string3 = file != null ? file.getPath() : FileIOPolicyRuntime.getFilenameFromArg(callContext, 0);
        } else if (PRE_MATCHERS_INIT.match(callContext)) {
            string3 = FileIOPolicyRuntime.getFilenameFromArg(callContext, 0);
            if (PRE_MATCH_RAF_INIT.match(callContext)) {
                category = callContext.getArg(1).getObjectValue().equals("r") ? CATEGORY_READ : CATEGORY_WRITE;
            }
        } else if (PRE_MATCH_URL_CONNECTION.match(callContext)) {
            URL uRL2 = null;
            if (string2.equals(METH_INIT)) {
                uRL2 = (URL)callContext.getArg(0).getObjectValue();
            } else if (string2.equals("connect")) {
                uRL2 = ((URLConnection)callContext.getTarget()).getURL();
            }
            String string4 = NetworkPolicyRuntime.getFileProtocolFilename(uRL2);
            if (null != string4) {
                string3 = string4;
                category = CATEGORY_READ;
            }
        } else if (PRE_MATCH_URL.match(callContext) && null != (string = NetworkPolicyRuntime.getFileProtocolFilename(uRL = (URL)callContext.getTarget()))) {
            string3 = string;
            category = CATEGORY_READ;
        }
        if (null == category) {
            return;
        }
        if (null == category.msgTag) {
            return;
        }
        if (this.allowAction(category, string3 = FileIOPolicyRuntime.canonicalizeFilePath(string3))) {
            return;
        }
        this.doStopAction(category, string3, callContext);
    }

    void _postFilter(CallContext callContext) {
    }

    private void doStopAction(Category category, String string, CallContext callContext) {
        String string2;
        String[] stringArray;
        String string3 = callContext.getRefName();
        if (null != string) {
            stringArray = new String[]{string, string3};
            string2 = category.msgTag;
        } else {
            stringArray = new String[]{string3};
            string2 = category.msgTagAlt;
        }
        this.stopAction(string2, stringArray);
    }

    private static String getFilenameFromArg(CallContext callContext, int n) {
        if (callContext.getNumArgs() <= n) {
            return null;
        }
        Object object = callContext.getArg(n).getObjectValue();
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof File) {
            return ((File)object).getPath();
        }
        return null;
    }

    private static String canonicalizeFilePath(String string) {
        if (null == string) {
            return null;
        }
        try {
            File file = new File(string);
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private boolean allowAction(Category category, String string) {
        boolean bl = this.getBoolPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_STATE_BOOL, false);
        if (bl) {
            String string2 = this.getStrPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_EXCLUDE_LIST, "");
            return !this.matchFile(string, string2);
        }
        String string3 = this.getStrPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_INCLUDE_LIST, "");
        return this.matchFile(string, string3);
    }

    private static String canonicalizePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c != File.separatorChar) {
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuffer.append(c);
            bl = true;
        }
        if (File.separatorChar != c) {
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer.toString();
    }

    private boolean matchFile(String string, String string2) {
        if (null == string) {
            return false;
        }
        String string3 = FileIOPolicyRuntime.canonicalizePath(string);
        String string4 = FileIOPolicyRuntime.replaceIn(string2, ENC_BACKSLASH, "\\");
        if (File.separatorChar == '\\') {
            string3 = string3.toLowerCase();
            string4 = string4.toLowerCase();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            int n;
            String string6 = stringTokenizer.nextToken();
            char c = '\u0000';
            if (string6.endsWith(File.separator + "*") || string6.endsWith(File.separator + "-")) {
                c = string6.charAt(string6.length() - 1);
                string6 = string6.substring(0, string6.length() - 1);
            }
            if (!string6.endsWith(File.separator)) {
                string6 = string6 + File.separator;
            }
            if (!(c == '-' ? string3.startsWith(string6) : (c == '*' ? string3.startsWith(string6) && ((n = (string5 = string3.substring(string6.length(), string3.length())).indexOf(File.separatorChar)) == -1 || n == string5.length() - 1) : string6.equals(string3)))) continue;
            return true;
        }
        return false;
    }

    private static String replaceIn(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (-1 == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        int n3 = 0;
        do {
            stringBuffer.append(string.substring(n3, n));
            stringBuffer.append(string3);
            n3 = n + n2;
        } while (string.length() > n3 && -1 != (n = string.indexOf(string2, n3)));
        if (string.length() > n3) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String string) {
            super(string);
        }

        PolicyRuntime make(Session session) {
            return new FileIOPolicyRuntime(session);
        }
    }

    public static class Category {
        public String name;
        public String msgTag;
        public String msgTagAlt;

        private Category(String string, String string2) {
            this(string, string2, (String)null);
        }

        private Category(String string, String string2, String string3) {
            this.name = string;
            this.msgTag = string2;
            this.msgTagAlt = null != string3 ? string3 : string2;
        }
    }
}

