/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.RuntimeClassRef;
import java.util.Enumeration;
import java.util.Vector;

public class MethodRefMatcher {
    private MatchTarget[] m_classNames;
    private MatchTarget[] m_methodNames;
    private MatchTarget[] m_argDescs;

    public static MethodRefMatcher make(String string) {
        return MethodRefMatcher.make(new String[]{string}, null, null);
    }

    public static MethodRefMatcher make(String string, String string2) {
        return MethodRefMatcher.make(new String[]{string}, new String[]{string2}, null);
    }

    public static MethodRefMatcher make(String string, String string2, String string3) {
        return MethodRefMatcher.make(new String[]{string}, new String[]{string2}, new String[]{string3});
    }

    public static MethodRefMatcher make(String string, String[] stringArray) {
        return MethodRefMatcher.make(new String[]{string}, stringArray, null);
    }

    public static MethodRefMatcher make(String[] stringArray, String string) {
        return MethodRefMatcher.make(stringArray, new String[]{string}, null);
    }

    public static MethodRefMatcher make(String[] stringArray) {
        return MethodRefMatcher.make(stringArray, null, null);
    }

    public static MethodRefMatcher make(String[] stringArray, String[] stringArray2) {
        return MethodRefMatcher.make(stringArray, stringArray2, null);
    }

    public static MethodRefMatcher make(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return new MethodRefMatcher(stringArray, stringArray2, stringArray3);
    }

    private MethodRefMatcher(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.m_classNames = MatchTarget.make(stringArray);
        this.m_methodNames = MatchTarget.make(stringArray2);
        this.m_argDescs = MatchTarget.make(stringArray3);
    }

    public boolean match(RuntimeClassRef runtimeClassRef) {
        return this.match(runtimeClassRef.getClassName(), runtimeClassRef.getRefName(), runtimeClassRef.getRefDesc());
    }

    public boolean match(String string, String string2, String string3) {
        if (!MatchTarget.match(string, this.m_classNames)) {
            return false;
        }
        if (!MatchTarget.match(string2, this.m_methodNames)) {
            return false;
        }
        return MatchTarget.match(string3, this.m_argDescs);
    }

    public boolean matchClass(String string) {
        return MatchTarget.match(string, this.m_classNames);
    }

    public boolean hasClass() {
        return null != this.m_classNames;
    }

    public boolean hasMethod() {
        return null != this.m_methodNames;
    }

    public boolean hasArg() {
        return null != this.m_argDescs;
    }

    public static class MatchTarget {
        private final String m_original;
        private final String m_target;
        private final boolean m_useStartsWith;
        private final boolean m_matchedResult;

        public static MatchTarget[] make(String[] stringArray) {
            if (null == stringArray) {
                return null;
            }
            MatchTarget[] matchTargetArray = new MatchTarget[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                matchTargetArray[i] = MatchTarget.make(stringArray[i]);
            }
            return matchTargetArray;
        }

        public static MatchTarget make(String string) {
            return new MatchTarget(string);
        }

        private MatchTarget(String string) {
            this.m_original = string;
            int n = 0;
            int n2 = string.length();
            if ('-' == string.charAt(0)) {
                this.m_matchedResult = false;
                ++n;
            } else {
                this.m_matchedResult = true;
            }
            if ('*' == string.charAt(n2 - 1)) {
                this.m_useStartsWith = true;
                --n2;
            } else {
                this.m_useStartsWith = false;
            }
            this.m_target = string.substring(n, n2);
        }

        public String getTargetValue() {
            return this.m_original;
        }

        public boolean getMatchedValue() {
            return this.m_matchedResult;
        }

        public static boolean match(String string, MatchTarget[] matchTargetArray) {
            if (null == matchTargetArray) {
                return true;
            }
            if (null == string) {
                return false;
            }
            for (int i = 0; i < matchTargetArray.length; ++i) {
                if (!matchTargetArray[i].matchInner(string)) continue;
                return matchTargetArray[i].getMatchedValue();
            }
            return false;
        }

        public boolean match(String string) {
            return this.matchInner(string) ? this.m_matchedResult : !this.m_matchedResult;
        }

        private boolean matchInner(String string) {
            return this.m_useStartsWith ? string.startsWith(this.m_target) : this.m_target.equalsIgnoreCase(string);
        }
    }

    public static class Set {
        private final Vector m_matchers = new Vector();
        private final Vector m_sets = new Vector();
        private final String m_prefix;

        public Set() {
            this.m_prefix = null;
        }

        public Set(String string) {
            this.m_prefix = string;
        }

        public Set makeSet() {
            Set set = new Set();
            this.m_sets.addElement(set);
            return set;
        }

        public Set makeSet(String string) {
            Set set = new Set(string);
            this.m_sets.addElement(set);
            return set;
        }

        public MethodRefMatcher make(String string) {
            return this.make(new String[]{string}, null, null);
        }

        public MethodRefMatcher make(String[] stringArray) {
            return this.make(stringArray, null, null);
        }

        public MethodRefMatcher make(String string, String string2) {
            return this.make(new String[]{string}, new String[]{string2}, null);
        }

        public MethodRefMatcher make(String string, String string2, String string3) {
            return this.make(new String[]{string}, new String[]{string2}, new String[]{string3});
        }

        public MethodRefMatcher make(String string, String string2, String[] stringArray) {
            return this.make(new String[]{string}, new String[]{string2}, stringArray);
        }

        public MethodRefMatcher make(String string, String[] stringArray) {
            return this.make(new String[]{string}, stringArray, null);
        }

        public MethodRefMatcher make(String string, String[] stringArray, String string2) {
            return this.make(new String[]{string}, stringArray, new String[]{string2});
        }

        public MethodRefMatcher make(String[] stringArray, String string) {
            return this.make(stringArray, new String[]{string}, null);
        }

        public MethodRefMatcher make(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            MethodRefMatcher methodRefMatcher = new MethodRefMatcher(stringArray, stringArray2, stringArray3);
            this.m_matchers.addElement(methodRefMatcher);
            return methodRefMatcher;
        }

        public boolean matchClass(String string) {
            Object object;
            if (null != this.m_prefix && !string.startsWith(this.m_prefix)) {
                return false;
            }
            Enumeration enumeration = this.m_sets.elements();
            while (enumeration.hasMoreElements()) {
                object = (Set)enumeration.nextElement();
                if (!((Set)object).matchClass(string)) continue;
                return true;
            }
            enumeration = this.m_matchers.elements();
            while (enumeration.hasMoreElements()) {
                object = (MethodRefMatcher)enumeration.nextElement();
                if (!((MethodRefMatcher)object).matchClass(string)) continue;
                return true;
            }
            return false;
        }

        public boolean match(String string, String string2, String string3) {
            Object object;
            if (null != this.m_prefix && !string.startsWith(this.m_prefix)) {
                return false;
            }
            Enumeration enumeration = this.m_sets.elements();
            while (enumeration.hasMoreElements()) {
                object = (Set)enumeration.nextElement();
                if (!((Set)object).match(string, string2, string3)) continue;
                return true;
            }
            enumeration = this.m_matchers.elements();
            while (enumeration.hasMoreElements()) {
                object = (MethodRefMatcher)enumeration.nextElement();
                if (!((MethodRefMatcher)object).match(string, string2, string3)) continue;
                return true;
            }
            return false;
        }

        public boolean match(RuntimeClassRef runtimeClassRef) {
            return this.match(runtimeClassRef.getClassName(), runtimeClassRef.getRefName(), runtimeClassRef.getRefDesc());
        }

        public MethodRefMatcher getMatch(String string, String string2, String string3) {
            Object object;
            if (null != this.m_prefix && !string.startsWith(this.m_prefix)) {
                return null;
            }
            Enumeration enumeration = this.m_sets.elements();
            while (enumeration.hasMoreElements()) {
                object = (Set)enumeration.nextElement();
                MethodRefMatcher methodRefMatcher = ((Set)object).getMatch(string, string2, string3);
                if (null == methodRefMatcher) continue;
                return methodRefMatcher;
            }
            enumeration = this.m_matchers.elements();
            while (enumeration.hasMoreElements()) {
                object = (MethodRefMatcher)enumeration.nextElement();
                if (!((MethodRefMatcher)object).match(string, string2, string3)) continue;
                return object;
            }
            return null;
        }

        public MethodRefMatcher getMatch(RuntimeClassRef runtimeClassRef) {
            return this.getMatch(runtimeClassRef.getClassName(), runtimeClassRef.getRefName(), runtimeClassRef.getRefDesc());
        }
    }
}

