/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.FileIOPolicyRuntime;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.io.File;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public final class NetworkPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime = NetworkPolicyRuntime.class$("com.trend.iwss.jscan.runtime.NetworkPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime);
    public static final String NAME = "Network";
    public static final String PROP_PREFIX = "net";
    public static final Factory FACT = new Factory("Network");
    public static final String CFG_NETWORK_CONNECT_SOURCE_BOOL = "connect_src";
    public static final String CFG_NETWORK_CONNECT_OTHER_BOOL = "connect_other";
    public static final String CFG_NETWORK_CONNECT_EXCLUDED_DOMAINS_LIST = "connect_ex_dom_list";
    public static final String CFG_NETWORK_CONNECT_INCLUDED_DOMAINS_LIST = "connect_in_dom_list";
    public static final String CFG_NETWORK_BIND_ENABLE = "bind_enable";
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set("java/net/");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_INIT = MATCHERS.make("java/net/ServerSocket", "<init>");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_INIT_I = MATCHERS.make("java/net/ServerSocket", "<init>", "(I*");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_BIND = MATCHERS.make("java/net/ServerSocket", "bind", "(Ljava/net/SocketAddress;*");
    public static final MethodRefMatcher MATCH_SOCKET_INIT_INETADDR = MATCHERS.make("java/net/Socket", "<init>", "(Ljava/net/InetAddress;*");
    public static final MethodRefMatcher MATCH_SOCKET_INIT_STRING = MATCHERS.make("java/net/Socket", "<init>", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_INIT_I = MATCHERS.make("java/net/DatagramSocket", "<init>", "(I*");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_SEND = MATCHERS.make("java/net/DatagramSocket", "send");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_RECEIVE = MATCHERS.make("java/net/DatagramSocket", "receive");
    public static final MethodRefMatcher MATCH_URL_CONNECTION_INIT = MATCHERS.make("java/net/URLConnection", "<init>");
    public static final MethodRefMatcher MATCH_URL_CONNECTION_CONNECT = MATCHERS.make("java/net/URLConnection", "connect");
    public static final MethodRefMatcher MATCH_URL_INIT = MATCHERS.make("java/net/URL", "<init>");
    public static final MethodRefMatcher MATCH_URL_OPEN = MATCHERS.make("java/net/URL", new String[]{"openConnection", "openStream", "getContent"});
    public static final String CLASS_INETADDRESS = "java.net.InetAddress";
    public static final String CLASS_INETSOCKETADDRESS = "java.net.InetSocketAddress";
    public static final String METH_INETSOCKETADDRESS_GETHOSTNAME = "getHostName";
    public static final String METH_INETSOCKETADDRESS_GETADDRESS = "getAddress";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_FTP = "ftp";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOOPBACK_IPADDR = "127.0.0.1";
    private String m_originURI = this.getStrProp("jscan.session.origin_uri", null);
    private String m_originHost = NetworkPolicyRuntime.getHostFromURI(this.m_originURI);
    private InetAddress m_originInetAddress = NetworkPolicyRuntime.getInetAddr(this.m_originHost);
    private boolean m_localBindEnabled = this.getBoolPolicyProp("bind_enable", false);
    private boolean m_connectToOriginEnabled = this.getBoolPolicyProp("connect_src", true);
    private boolean m_connectToOtherEnabled = this.getBoolPolicyProp("connect_other", false);
    private String m_otherDomainsExceptions;
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime;

    NetworkPolicyRuntime(Session session) {
        super(NAME, PROP_PREFIX, session);
        String string = this.m_connectToOtherEnabled ? CFG_NETWORK_CONNECT_EXCLUDED_DOMAINS_LIST : CFG_NETWORK_CONNECT_INCLUDED_DOMAINS_LIST;
        this.m_otherDomainsExceptions = this.getStrPolicyProp(string, "");
    }

    public static void preFilter(CallContext callContext) {
        PolicyRuntime.preFilter(callContext, FACT);
    }

    public static void postFilter(CallContext callContext) {
        PolicyRuntime.postFilter(callContext, FACT);
    }

    void _preFilter(CallContext callContext) {
        if (MATCH_SERVER_SOCKET_INIT_I.match(callContext)) {
            int n = callContext.getArg(0).getIntValue();
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local", "" + n);
                return;
            }
        } else if (MATCH_SERVER_SOCKET_INIT.match(callContext)) {
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local_unspec");
                return;
            }
        } else if (MATCH_SOCKET_INIT_INETADDR.match(callContext)) {
            InetAddress inetAddress = (InetAddress)callContext.getArg(0).getObjectValue();
            if (!this.allowInetAddr(inetAddress)) {
                this.stopAction("instr.action.connect", inetAddress.getHostName());
                return;
            }
        } else if (MATCH_SOCKET_INIT_STRING.match(callContext)) {
            String string = (String)callContext.getArg(0).getObjectValue();
            if (!this.allowHostName(string)) {
                this.stopAction("instr.action.connect", string);
                return;
            }
        } else if (MATCH_DATAGRAM_SOCKET_INIT_I.match(callContext)) {
            int n = callContext.getArg(0).getIntValue();
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local", "" + n);
                return;
            }
        } else if (MATCH_DATAGRAM_SOCKET_SEND.match(callContext)) {
            DatagramPacket datagramPacket = (DatagramPacket)callContext.getArg(0).getObjectValue();
            InetAddress inetAddress = datagramPacket.getAddress();
            if (!this.allowInetAddr(inetAddress)) {
                this.stopAction("instr.action.send_data", inetAddress.toString());
                return;
            }
        } else if (MATCH_SERVER_SOCKET_BIND.match(callContext)) {
            Object object = callContext.getArg(0).getObjectValue();
            this.checkInetSocketAddr(object);
        } else if (MATCH_URL_CONNECTION_INIT.match(callContext)) {
            this.checkURL((URL)callContext.getArg(0).getObjectValue(), callContext);
        } else if (MATCH_URL_CONNECTION_CONNECT.match(callContext)) {
            this.checkURL(((URLConnection)callContext.getTarget()).getURL(), callContext);
        } else if (MATCH_URL_OPEN.match(callContext)) {
            this.checkURL((URL)callContext.getTarget(), callContext);
        }
    }

    void _postFilter(CallContext callContext) {
        if (MATCH_DATAGRAM_SOCKET_RECEIVE.match(callContext)) {
            DatagramPacket datagramPacket = (DatagramPacket)callContext.getArg(0).getObjectValue();
            InetAddress inetAddress = datagramPacket.getAddress();
            if (!this.allowInetAddr(inetAddress)) {
                this.stopAction("instr.action.receive_data", inetAddress.toString());
                return;
            }
        } else if (MATCH_URL_INIT.match(callContext)) {
            this.checkURL((URL)callContext.getTarget(), callContext);
        }
    }

    public static boolean isFileProtocol(URL uRL) {
        return null != NetworkPolicyRuntime.getFileProtocolFilename(uRL);
    }

    public static String getFileProtocolFilename(URL uRL) {
        if (null == uRL) {
            return null;
        }
        String string = uRL.getProtocol();
        if (URL_PROTOCOL_FILE.equalsIgnoreCase(string)) {
            return NetworkPolicyRuntime.toNormalFilePath(uRL.getFile());
        }
        if (URL_PROTOCOL_FTP.equalsIgnoreCase(string)) {
            return NetworkPolicyRuntime.toNormalFilePath(uRL.getFile());
        }
        if (URL_PROTOCOL_JAR.equalsIgnoreCase(string)) {
            URL uRL2 = NetworkPolicyRuntime.fileUrlFromJarUrl(uRL);
            if (null == uRL2) {
                return null;
            }
            String string2 = uRL2.getProtocol();
            if (!URL_PROTOCOL_FILE.equalsIgnoreCase(string2)) {
                return null;
            }
            return NetworkPolicyRuntime.toNormalFilePath(uRL2.getFile());
        }
        return null;
    }

    public static String toNormalFilePath(String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        if (string2.length() >= 3) {
            if (string2.charAt(2) == '|') {
                string2 = string2.substring(0, 2) + ":" + string2.substring(3, string2.length());
            }
            if (string2.charAt(0) == File.separatorChar && string2.charAt(2) == ':') {
                string2 = string2.substring(1);
            }
        }
        return string2;
    }

    public static boolean isLocalFileProtocol(URL uRL) {
        if (null == uRL) {
            return false;
        }
        if (!NetworkPolicyRuntime.isFileProtocol(uRL)) {
            return false;
        }
        return NetworkPolicyRuntime.isLocal(uRL);
    }

    public static boolean isLocal(URL uRL) {
        if (null == uRL) {
            return false;
        }
        URL uRL2 = uRL;
        if (URL_PROTOCOL_JAR.equalsIgnoreCase(uRL2.getProtocol()) && null == (uRL2 = NetworkPolicyRuntime.fileUrlFromJarUrl(uRL2))) {
            return false;
        }
        String string = uRL2.getHost();
        if (null == string) {
            return true;
        }
        if (LOCALHOST_NAME.equalsIgnoreCase(string)) {
            return true;
        }
        if (LOOPBACK_IPADDR.equalsIgnoreCase(string)) {
            return true;
        }
        InetAddress inetAddress = NetworkPolicyRuntime.getLocalhostInetAddr();
        if (null == inetAddress) {
            return false;
        }
        return string.equals(inetAddress.getHostName());
    }

    private static URL fileUrlFromJarUrl(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf("!/");
        String string2 = -1 != n ? string.substring(0, n) : string;
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void checkURL(URL uRL, CallContext callContext) {
        if (NetworkPolicyRuntime.isLocalFileProtocol(uRL)) {
            PolicyRuntime.preFilter(callContext, FileIOPolicyRuntime.FACT);
            return;
        }
        String string = uRL.getHost();
        if (!this.allowHostName(string)) {
            this.stopAction("instr.action.connect", uRL.toString());
        }
    }

    private void checkInetSocketAddr(Object object) {
        String string = PolicyRuntime.invokeStringGetter(object, CLASS_INETSOCKETADDRESS, METH_INETSOCKETADDRESS_GETHOSTNAME);
        Object object2 = PolicyRuntime.invokeZeroArgMethod(object, CLASS_INETSOCKETADDRESS, METH_INETSOCKETADDRESS_GETADDRESS, CLASS_INETADDRESS);
        if (null == string && null == object2) {
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local_unspec");
            }
            return;
        }
        InetAddress inetAddress = (InetAddress)object2;
        if (!this.allow(string, inetAddress)) {
            this.stopAction("instr.action.connect", object.toString());
        }
    }

    private boolean allowInetAddr(InetAddress inetAddress) {
        String string = NetworkPolicyRuntime.getHostNameFromInetAddr(inetAddress);
        return this.allow(string, inetAddress);
    }

    private boolean allowHostName(String string) {
        InetAddress inetAddress = NetworkPolicyRuntime.getInetAddr(string);
        return this.allow(string, inetAddress);
    }

    private boolean allow(String string, InetAddress inetAddress) {
        if (this.matchOrigin(string, inetAddress)) {
            return this.m_connectToOriginEnabled;
        }
        if (this.m_connectToOtherEnabled) {
            return !this.matchList(string, inetAddress, this.m_otherDomainsExceptions);
        }
        return this.matchList(string, inetAddress, this.m_otherDomainsExceptions);
    }

    private boolean matchOrigin(String string, InetAddress inetAddress) {
        if (null == this.m_originURI) {
            return false;
        }
        if (null != string && string.equals(this.m_originHost)) {
            return true;
        }
        return null != inetAddress && inetAddress.equals(this.m_originInetAddress);
    }

    private boolean matchList(String string, InetAddress inetAddress, String string2) {
        String string3 = NetworkPolicyRuntime.getHostAddrFromInetAddr(inetAddress);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("*")) {
                return true;
            }
            if (!NetworkPolicyRuntime.matchToken(string4, string) && !NetworkPolicyRuntime.matchToken(string4, string3)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchToken(String string, String string2) {
        if (null == string2) {
            return false;
        }
        if (string.startsWith("*.")) {
            return string2.equals(string.substring(2, string.length())) || string2.endsWith(string.substring(1, string.length()));
        }
        return string.equals(string2);
    }

    private static String getHostFromURI(String string) {
        if (null == string) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            return uRL.getHost();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static InetAddress getLocalhostInetAddr() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static InetAddress getInetAddr(String string) {
        if (null == string) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static String getHostAddrFromInetAddr(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            return inetAddress.getHostAddress();
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static String getHostNameFromInetAddr(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            return inetAddress.getHostName();
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String string) {
            super(string);
        }

        PolicyRuntime make(Session session) {
            return new NetworkPolicyRuntime(session);
        }
    }
}

