/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PolicyProps {
    private final Properties m_props;

    public static PolicyProps make(String string) {
        if (string == null) {
            return new PolicyProps();
        }
        Properties properties = new Properties();
        byte[] byArray = PolicyProps.getAsciiBytes(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Error loading Policy properties");
            iOException.printStackTrace();
        }
        return new PolicyProps(properties);
    }

    public boolean hasProps() {
        return 0 < ((Hashtable)this.m_props).size();
    }

    public static byte[] getAsciiBytes(String string) {
        if (null == string || 0 == string.length()) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public PolicyProps() {
        this.m_props = new Properties();
    }

    private PolicyProps(Properties properties) {
        this.m_props = properties;
    }

    public String getStrProp(String string, String string2) {
        String string3 = this.getProp(string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    public String getB64StrProp(String string, String string2) {
        String string3 = this.getProp(string);
        if (null == string3) {
            return string2;
        }
        try {
            return new String(Base64.decode(string3), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("UTF-8 encoding not recognized");
            unsupportedEncodingException.printStackTrace();
            return string2;
        }
    }

    public int getIntProp(String string, int n) {
        String string2 = this.getProp(string);
        if (null == string2) {
            return n;
        }
        if ("".equals(string2)) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("The value for numeric configuration property \"" + string + "\" is invalid, using \"" + n + "\" as default value");
            return n;
        }
    }

    public boolean getBoolProp(String string, boolean bl) {
        String string2 = this.getProp(string);
        if (null == string2) {
            return bl;
        }
        if ("".equals(string2)) {
            return bl;
        }
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("on".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("off".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("enable".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("disable".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("enabled".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("disabled".equalsIgnoreCase(string2)) {
            return false;
        }
        System.err.println("The value for boolean configuration property \"" + string + "\" is invalid, using \"" + bl + "\" as default value");
        return bl;
    }

    public String getStrPolicyProp(String string, String string2, String string3) {
        String string4 = this.composeKey(string, string2);
        return this.getStrProp(string4, string3);
    }

    public int getIntPolicyProp(String string, String string2, int n) {
        String string3 = this.composeKey(string, string2);
        return this.getIntProp(string3, n);
    }

    public boolean getBoolPolicyProp(String string, String string2, boolean bl) {
        String string3 = this.composeKey(string, string2);
        return this.getBoolProp(string3, bl);
    }

    private String getProp(String string) {
        if (0 == ((Hashtable)this.m_props).size()) {
            System.err.println("-- PolicyProps uninitialized on access of '" + string + "'");
        }
        return this.m_props.getProperty(string);
    }

    private String composeKey(String string, String string2) {
        return string == null ? string2 : string + "." + string2;
    }

    public void dbgDumpProps() {
        System.err.println("Current policy properties:");
        if (0 == ((Hashtable)this.m_props).size()) {
            System.err.println("\t(-none - uninitialized-)");
            return;
        }
        Enumeration enumeration = ((Hashtable)this.m_props).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.m_props.getProperty(string);
            System.err.println("\t" + string + ": " + string2);
        }
    }
}

